/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.core.ApiService;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_SubscriberSettings;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.ReassignmentHandler;
import com.google.cloud.pubsublite.cloudpubsub.Subscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.AckSetTrackerImpl;
import com.google.cloud.pubsublite.cloudpubsub.internal.AssigningSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.MultiPartitionSubscriber;
import com.google.cloud.pubsublite.cloudpubsub.internal.PartitionSubscriberFactory;
import com.google.cloud.pubsublite.cloudpubsub.internal.SinglePartitionSubscriber;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.ApiServiceUtils;
import com.google.cloud.pubsublite.internal.wire.AssignerFactory;
import com.google.cloud.pubsublite.internal.wire.AssignerSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceSettings;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import com.google.common.collect.ImmutableList;
import com.google.pubsub.v1.PubsubMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class SubscriberSettings {
    abstract MessageReceiver receiver();

    abstract SubscriptionPath subscriptionPath();

    abstract FlowControlSettings perPartitionFlowControlSettings();

    abstract List<Partition> partitions();

    abstract Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer();

    abstract CredentialsProvider credentialsProvider();

    abstract PubsubContext.Framework framework();

    abstract Optional<SubscriberServiceClient> subscriberServiceClient();

    abstract Optional<CursorServiceClient> cursorServiceClient();

    abstract Optional<PartitionAssignmentServiceClient> assignmentServiceClient();

    abstract Optional<NackHandler> nackHandler();

    abstract ReassignmentHandler reassignmentHandler();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberSettings.Builder().setFramework(PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM")).setPartitions((List<Partition>)ImmutableList.of()).setCredentialsProvider((CredentialsProvider)SubscriberServiceSettings.defaultCredentialsProviderBuilder().build()).setReassignmentHandler((before, after) -> {});
    }

    private SubscriberServiceClient newSubscriberServiceClient() throws ApiException {
        if (this.subscriberServiceClient().isPresent()) {
            return this.subscriberServiceClient().get();
        }
        try {
            return SubscriberServiceClient.create((SubscriberServiceSettings)((Object)ServiceClients.addDefaultSettings(this.subscriptionPath().location().extractRegion(), SubscriberServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private CursorServiceClient newCursorServiceClient() throws ApiException {
        if (this.cursorServiceClient().isPresent()) {
            return this.cursorServiceClient().get();
        }
        try {
            return CursorServiceClient.create((CursorServiceSettings)((Object)ServiceClients.addDefaultSettings(this.subscriptionPath().location().extractRegion(), CursorServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    PartitionSubscriberFactory getPartitionSubscriberFactory() {
        final SubscriberServiceClient client = this.newSubscriberServiceClient();
        final CursorServiceClient cursorClient = this.newCursorServiceClient();
        return new PartitionSubscriberFactory(){

            @Override
            public Subscriber newSubscriber(Partition partition) {
                SubscriberBuilder.Builder wireSubscriberBuilder = SubscriberBuilder.newBuilder().setPartition(partition).setSubscriptionPath(SubscriberSettings.this.subscriptionPath()).setStreamFactory(responseStream -> {
                    GrpcCallContext context = ServiceClients.getCallContext(PubsubContext.of(SubscriberSettings.this.framework()), RoutingMetadata.of(SubscriberSettings.this.subscriptionPath(), partition));
                    return client.subscribeCallable().splitCall(responseStream, (ApiCallContext)context);
                }).setInitialLocation(SeekRequest.newBuilder().setNamedTarget(SeekRequest.NamedTarget.COMMITTED_CURSOR).build());
                Committer wireCommitter = CommitterSettings.newBuilder().setSubscriptionPath(SubscriberSettings.this.subscriptionPath()).setPartition(partition).setStreamFactory(responseStream -> cursorClient.streamingCommitCursorCallable().splitCall(responseStream)).build().instantiate();
                return new SinglePartitionSubscriber(SubscriberSettings.this.receiver(), MessageTransforms.addIdCpsSubscribeTransformer(partition, SubscriberSettings.this.transformer().orElse(MessageTransforms.toCpsSubscribeTransformer())), new AckSetTrackerImpl(wireCommitter), SubscriberSettings.this.nackHandler().orElse(new NackHandler(){}), (messageConsumer, resetHandler) -> wireSubscriberBuilder.setMessageConsumer(messageConsumer).setResetHandler(resetHandler).build(), SubscriberSettings.this.perPartitionFlowControlSettings());
            }

            @Override
            public void close() {
                try (SubscriberServiceClient c1 = client;){
                    CursorServiceClient c2 = cursorClient;
                    Throwable throwable = null;
                    if (c2 != null) {
                        if (throwable != null) {
                            try {
                                c2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            c2.close();
                        }
                    }
                }
            }
        };
    }

    private PartitionAssignmentServiceClient getAssignmentServiceClient() throws ApiException {
        if (this.assignmentServiceClient().isPresent()) {
            return this.assignmentServiceClient().get();
        }
        try {
            return PartitionAssignmentServiceClient.create((PartitionAssignmentServiceSettings)((Object)ServiceClients.addDefaultSettings(this.subscriptionPath().location().extractRegion(), PartitionAssignmentServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    Subscriber instantiate() throws ApiException {
        PartitionSubscriberFactory partitionSubscriberFactory = this.getPartitionSubscriberFactory();
        if (this.partitions().isEmpty()) {
            AssignerSettings.Builder assignerSettings = AssignerSettings.newBuilder().setSubscriptionPath(this.subscriptionPath()).setServiceClient(this.getAssignmentServiceClient());
            AssignerFactory assignerFactory = receiver -> assignerSettings.setReceiver(receiver).build().instantiate();
            return new AssigningSubscriber(partitionSubscriberFactory, this.reassignmentHandler(), assignerFactory);
        }
        ArrayList<ApiService> services = new ArrayList<ApiService>();
        for (Partition partition : this.partitions()) {
            try {
                services.add((ApiService)partitionSubscriberFactory.newSubscriber(partition));
            }
            catch (CheckedApiException e) {
                throw e.underlying;
            }
        }
        services.add(ApiServiceUtils.autoCloseableAsApiService(partitionSubscriberFactory));
        return MultiPartitionSubscriber.of(services);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setReceiver(MessageReceiver var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPerPartitionFlowControlSettings(FlowControlSettings var1);

        public abstract Builder setPartitions(List<Partition> var1);

        public abstract Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> var1);

        public abstract Builder setCredentialsProvider(CredentialsProvider var1);

        public abstract Builder setFramework(PubsubContext.Framework var1);

        public abstract Builder setSubscriberServiceClient(SubscriberServiceClient var1);

        public abstract Builder setCursorServiceClient(CursorServiceClient var1);

        public abstract Builder setAssignmentServiceClient(PartitionAssignmentServiceClient var1);

        public abstract Builder setNackHandler(NackHandler var1);

        public abstract Builder setReassignmentHandler(ReassignmentHandler var1);

        public abstract SubscriberSettings build();
    }
}

