/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.common.util.concurrent.Monitor;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

public final class SerialExecutor
implements AutoCloseable,
Executor {
    private final Executor executor;
    private final CloseableMonitor monitor = new CloseableMonitor();
    private final Monitor.Guard isInactive;
    @GuardedBy(value="monitor.monitor")
    private final Queue<Runnable> tasks;
    @GuardedBy(value="monitor.monitor")
    private boolean isTaskActive;
    @GuardedBy(value="monitor.monitor")
    private boolean isShutdown;

    public SerialExecutor(Executor executor) {
        this.isInactive = new Monitor.Guard(this.monitor.monitor){

            public boolean isSatisfied() {
                return !SerialExecutor.this.isTaskActive;
            }
        };
        this.executor = executor;
        this.tasks = new ArrayDeque<Runnable>();
        this.isTaskActive = false;
        this.isShutdown = false;
    }

    public void waitUntilInactive() {
        CloseableMonitor.Hold h = this.monitor.enterWhenUninterruptibly(this.isInactive);
        Throwable throwable = null;
        if (h != null) {
            if (throwable != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                h.close();
            }
        }
    }

    @Override
    public void close() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.isShutdown = true;
        }
    }

    @Override
    public void execute(Runnable r) {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            if (this.isShutdown) {
                return;
            }
            this.tasks.add(() -> {
                try {
                    if (this.shouldExecuteTask()) {
                        r.run();
                    }
                }
                finally {
                    this.scheduleNextTask();
                }
            });
            if (!this.isTaskActive) {
                this.scheduleNextTask();
            }
        }
    }

    private boolean shouldExecuteTask() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            boolean bl = !this.isShutdown;
            return bl;
        }
    }

    private void scheduleNextTask() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            boolean bl = this.isTaskActive = !this.tasks.isEmpty() && !this.isShutdown;
            if (this.isTaskActive) {
                this.executor.execute(this.tasks.poll());
            }
        }
    }
}

