/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.internal.wire.SubscriberImpl;
import com.google.cloud.pubsublite.internal.wire.SubscriberResetHandler;
import com.google.cloud.pubsublite.proto.InitialSubscribeRequest;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.util.List;
import java.util.function.Consumer;

@AutoValue
public abstract class SubscriberBuilder {
    abstract Consumer<List<SequencedMessage>> messageConsumer();

    abstract SubscriptionPath subscriptionPath();

    abstract Partition partition();

    abstract StreamFactories.SubscribeStreamFactory streamFactory();

    abstract SeekRequest initialLocation();

    abstract SubscriberResetHandler resetHandler();

    abstract boolean retryStreamRaces();

    public static Builder newBuilder() {
        return new AutoValue_SubscriberBuilder.Builder().setResetHandler(SubscriberResetHandler::unhandled).setRetryStreamRaces(true);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMessageConsumer(Consumer<List<SequencedMessage>> var1);

        public abstract Builder setSubscriptionPath(SubscriptionPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setStreamFactory(StreamFactories.SubscribeStreamFactory var1);

        public abstract Builder setInitialLocation(SeekRequest var1);

        public abstract Builder setResetHandler(SubscriberResetHandler var1);

        public abstract Builder setRetryStreamRaces(boolean var1);

        abstract SubscriberBuilder autoBuild();

        public Subscriber build() throws ApiException {
            SubscriberBuilder autoBuilt = this.autoBuild();
            InitialSubscribeRequest initialSubscribeRequest = InitialSubscribeRequest.newBuilder().setSubscription(autoBuilt.subscriptionPath().toString()).setPartition(autoBuilt.partition().value()).build();
            return new SubscriberImpl(autoBuilt.streamFactory(), initialSubscribeRequest, autoBuilt.initialLocation(), autoBuilt.messageConsumer(), autoBuilt.resetHandler(), autoBuilt.retryStreamRaces());
        }
    }
}

