/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.core.GaxProperties;
import com.google.common.annotations.VisibleForTesting;

final class Versions {
    private final String versionString;
    private static final Versions VERSIONS = new Versions();
    static final int MAJOR_VERSION = VERSIONS.getMajorVersion();
    static final int MINOR_VERSION = VERSIONS.getMinorVersion();

    @VisibleForTesting
    Versions(String versionString) {
        this.versionString = versionString;
    }

    private Versions() {
        this(GaxProperties.getLibraryVersion(Versions.class));
    }

    private String[] getVersionSplits() {
        try {
            return this.versionString.split("\\.");
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @VisibleForTesting
    int getMajorVersion() {
        String[] splits = this.getVersionSplits();
        if (splits.length != 3) {
            return 0;
        }
        try {
            return Integer.parseInt(splits[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @VisibleForTesting
    int getMinorVersion() {
        String[] splits = this.getVersionSplits();
        if (splits.length != 3) {
            return 0;
        }
        try {
            return Integer.parseInt(splits[1]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

