/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.cloudpubsub.NackHandler;
import com.google.cloud.pubsublite.cloudpubsub.PartitionSubscriberClientSupplier;
import com.google.cloud.pubsublite.cloudpubsub.ReassignmentHandler;
import com.google.cloud.pubsublite.cloudpubsub.SubscriberSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.PartitionAssignmentServiceClient;
import com.google.pubsub.v1.PubsubMessage;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

final class AutoValue_SubscriberSettings
extends SubscriberSettings {
    private final MessageReceiver receiver;
    private final SubscriptionPath subscriptionPath;
    private final FlowControlSettings perPartitionFlowControlSettings;
    private final List<Partition> partitions;
    private final Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer;
    private final CredentialsProvider credentialsProvider;
    private final PubsubContext.Framework framework;
    private final Optional<PartitionSubscriberClientSupplier> partitionSubscriberClientSupplier;
    private final Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier;
    private final Optional<PartitionAssignmentServiceClient> assignmentServiceClient;
    private final Optional<NackHandler> nackHandler;
    private final ReassignmentHandler reassignmentHandler;

    private AutoValue_SubscriberSettings(MessageReceiver receiver, SubscriptionPath subscriptionPath, FlowControlSettings perPartitionFlowControlSettings, List<Partition> partitions, Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer, CredentialsProvider credentialsProvider, PubsubContext.Framework framework, Optional<PartitionSubscriberClientSupplier> partitionSubscriberClientSupplier, Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier, Optional<PartitionAssignmentServiceClient> assignmentServiceClient, Optional<NackHandler> nackHandler, ReassignmentHandler reassignmentHandler) {
        this.receiver = receiver;
        this.subscriptionPath = subscriptionPath;
        this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
        this.partitions = partitions;
        this.transformer = transformer;
        this.credentialsProvider = credentialsProvider;
        this.framework = framework;
        this.partitionSubscriberClientSupplier = partitionSubscriberClientSupplier;
        this.cursorServiceClientSupplier = cursorServiceClientSupplier;
        this.assignmentServiceClient = assignmentServiceClient;
        this.nackHandler = nackHandler;
        this.reassignmentHandler = reassignmentHandler;
    }

    @Override
    MessageReceiver receiver() {
        return this.receiver;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    FlowControlSettings perPartitionFlowControlSettings() {
        return this.perPartitionFlowControlSettings;
    }

    @Override
    List<Partition> partitions() {
        return this.partitions;
    }

    @Override
    Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer() {
        return this.transformer;
    }

    @Override
    CredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    PubsubContext.Framework framework() {
        return this.framework;
    }

    @Override
    Optional<PartitionSubscriberClientSupplier> partitionSubscriberClientSupplier() {
        return this.partitionSubscriberClientSupplier;
    }

    @Override
    Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier() {
        return this.cursorServiceClientSupplier;
    }

    @Override
    Optional<PartitionAssignmentServiceClient> assignmentServiceClient() {
        return this.assignmentServiceClient;
    }

    @Override
    Optional<NackHandler> nackHandler() {
        return this.nackHandler;
    }

    @Override
    ReassignmentHandler reassignmentHandler() {
        return this.reassignmentHandler;
    }

    public String toString() {
        return "SubscriberSettings{receiver=" + this.receiver + ", subscriptionPath=" + this.subscriptionPath + ", perPartitionFlowControlSettings=" + this.perPartitionFlowControlSettings + ", partitions=" + this.partitions + ", transformer=" + this.transformer + ", credentialsProvider=" + this.credentialsProvider + ", framework=" + this.framework + ", partitionSubscriberClientSupplier=" + this.partitionSubscriberClientSupplier + ", cursorServiceClientSupplier=" + this.cursorServiceClientSupplier + ", assignmentServiceClient=" + this.assignmentServiceClient + ", nackHandler=" + this.nackHandler + ", reassignmentHandler=" + this.reassignmentHandler + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberSettings) {
            SubscriberSettings that = (SubscriberSettings)o;
            return this.receiver.equals(that.receiver()) && this.subscriptionPath.equals(that.subscriptionPath()) && this.perPartitionFlowControlSettings.equals(that.perPartitionFlowControlSettings()) && this.partitions.equals(that.partitions()) && this.transformer.equals(that.transformer()) && this.credentialsProvider.equals(that.credentialsProvider()) && this.framework.equals(that.framework()) && this.partitionSubscriberClientSupplier.equals(that.partitionSubscriberClientSupplier()) && this.cursorServiceClientSupplier.equals(that.cursorServiceClientSupplier()) && this.assignmentServiceClient.equals(that.assignmentServiceClient()) && this.nackHandler.equals(that.nackHandler()) && this.reassignmentHandler.equals(that.reassignmentHandler());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.receiver.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.perPartitionFlowControlSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.transformer.hashCode();
        h$ *= 1000003;
        h$ ^= this.credentialsProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.framework.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionSubscriberClientSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.cursorServiceClientSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.assignmentServiceClient.hashCode();
        h$ *= 1000003;
        h$ ^= this.nackHandler.hashCode();
        h$ *= 1000003;
        return h$ ^= this.reassignmentHandler.hashCode();
    }

    static final class Builder
    extends SubscriberSettings.Builder {
        private MessageReceiver receiver;
        private SubscriptionPath subscriptionPath;
        private FlowControlSettings perPartitionFlowControlSettings;
        private List<Partition> partitions;
        private Optional<MessageTransformer<SequencedMessage, PubsubMessage>> transformer = Optional.empty();
        private CredentialsProvider credentialsProvider;
        private PubsubContext.Framework framework;
        private Optional<PartitionSubscriberClientSupplier> partitionSubscriberClientSupplier = Optional.empty();
        private Optional<Supplier<CursorServiceClient>> cursorServiceClientSupplier = Optional.empty();
        private Optional<PartitionAssignmentServiceClient> assignmentServiceClient = Optional.empty();
        private Optional<NackHandler> nackHandler = Optional.empty();
        private ReassignmentHandler reassignmentHandler;

        Builder() {
        }

        @Override
        public SubscriberSettings.Builder setReceiver(MessageReceiver receiver) {
            if (receiver == null) {
                throw new NullPointerException("Null receiver");
            }
            this.receiver = receiver;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setPerPartitionFlowControlSettings(FlowControlSettings perPartitionFlowControlSettings) {
            if (perPartitionFlowControlSettings == null) {
                throw new NullPointerException("Null perPartitionFlowControlSettings");
            }
            this.perPartitionFlowControlSettings = perPartitionFlowControlSettings;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setPartitions(List<Partition> partitions) {
            if (partitions == null) {
                throw new NullPointerException("Null partitions");
            }
            this.partitions = partitions;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setTransformer(MessageTransformer<SequencedMessage, PubsubMessage> transformer) {
            this.transformer = Optional.of(transformer);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            if (credentialsProvider == null) {
                throw new NullPointerException("Null credentialsProvider");
            }
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setFramework(PubsubContext.Framework framework) {
            if (framework == null) {
                throw new NullPointerException("Null framework");
            }
            this.framework = framework;
            return this;
        }

        @Override
        public SubscriberSettings.Builder setPartitionSubscriberClientSupplier(PartitionSubscriberClientSupplier partitionSubscriberClientSupplier) {
            this.partitionSubscriberClientSupplier = Optional.of(partitionSubscriberClientSupplier);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setCursorServiceClientSupplier(Supplier<CursorServiceClient> cursorServiceClientSupplier) {
            this.cursorServiceClientSupplier = Optional.of(cursorServiceClientSupplier);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setAssignmentServiceClient(PartitionAssignmentServiceClient assignmentServiceClient) {
            this.assignmentServiceClient = Optional.of(assignmentServiceClient);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setNackHandler(NackHandler nackHandler) {
            this.nackHandler = Optional.of(nackHandler);
            return this;
        }

        @Override
        public SubscriberSettings.Builder setReassignmentHandler(ReassignmentHandler reassignmentHandler) {
            if (reassignmentHandler == null) {
                throw new NullPointerException("Null reassignmentHandler");
            }
            this.reassignmentHandler = reassignmentHandler;
            return this;
        }

        @Override
        public SubscriberSettings build() {
            if (this.receiver == null || this.subscriptionPath == null || this.perPartitionFlowControlSettings == null || this.partitions == null || this.credentialsProvider == null || this.framework == null || this.reassignmentHandler == null) {
                StringBuilder missing = new StringBuilder();
                if (this.receiver == null) {
                    missing.append(" receiver");
                }
                if (this.subscriptionPath == null) {
                    missing.append(" subscriptionPath");
                }
                if (this.perPartitionFlowControlSettings == null) {
                    missing.append(" perPartitionFlowControlSettings");
                }
                if (this.partitions == null) {
                    missing.append(" partitions");
                }
                if (this.credentialsProvider == null) {
                    missing.append(" credentialsProvider");
                }
                if (this.framework == null) {
                    missing.append(" framework");
                }
                if (this.reassignmentHandler == null) {
                    missing.append(" reassignmentHandler");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberSettings(this.receiver, this.subscriptionPath, this.perPartitionFlowControlSettings, this.partitions, this.transformer, this.credentialsProvider, this.framework, this.partitionSubscriberClientSupplier, this.cursorServiceClientSupplier, this.assignmentServiceClient, this.nackHandler, this.reassignmentHandler);
        }
    }
}

