package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CursorClientSettings extends CursorClientSettings {

  private final CloudRegion region;

  private final Optional<CursorServiceClient> serviceClient;

  private AutoValue_CursorClientSettings(
      CloudRegion region,
      Optional<CursorServiceClient> serviceClient) {
    this.region = region;
    this.serviceClient = serviceClient;
  }

  @Override
  CloudRegion region() {
    return region;
  }

  @Override
  Optional<CursorServiceClient> serviceClient() {
    return serviceClient;
  }

  @Override
  public String toString() {
    return "CursorClientSettings{"
        + "region=" + region + ", "
        + "serviceClient=" + serviceClient
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CursorClientSettings) {
      CursorClientSettings that = (CursorClientSettings) o;
      return this.region.equals(that.region())
          && this.serviceClient.equals(that.serviceClient());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= region.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    return h$;
  }

  static final class Builder extends CursorClientSettings.Builder {
    private CloudRegion region;
    private Optional<CursorServiceClient> serviceClient = Optional.empty();
    Builder() {
    }
    @Override
    public CursorClientSettings.Builder setRegion(CloudRegion region) {
      if (region == null) {
        throw new NullPointerException("Null region");
      }
      this.region = region;
      return this;
    }
    @Override
    public CursorClientSettings.Builder setServiceClient(CursorServiceClient serviceClient) {
      this.serviceClient = Optional.of(serviceClient);
      return this;
    }
    @Override
    public CursorClientSettings build() {
      if (this.region == null) {
        String missing = " region";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CursorClientSettings(
          this.region,
          this.serviceClient);
    }
  }

}
