package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CommitterSettings extends CommitterSettings {

  private final SubscriptionPath subscriptionPath;

  private final Partition partition;

  private final CursorServiceClient serviceClient;

  private AutoValue_CommitterSettings(
      SubscriptionPath subscriptionPath,
      Partition partition,
      CursorServiceClient serviceClient) {
    this.subscriptionPath = subscriptionPath;
    this.partition = partition;
    this.serviceClient = serviceClient;
  }

  @Override
  SubscriptionPath subscriptionPath() {
    return subscriptionPath;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  CursorServiceClient serviceClient() {
    return serviceClient;
  }

  @Override
  public String toString() {
    return "CommitterSettings{"
        + "subscriptionPath=" + subscriptionPath + ", "
        + "partition=" + partition + ", "
        + "serviceClient=" + serviceClient
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CommitterSettings) {
      CommitterSettings that = (CommitterSettings) o;
      return this.subscriptionPath.equals(that.subscriptionPath())
          && this.partition.equals(that.partition())
          && this.serviceClient.equals(that.serviceClient());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= subscriptionPath.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    return h$;
  }

  static final class Builder extends CommitterSettings.Builder {
    private SubscriptionPath subscriptionPath;
    private Partition partition;
    private CursorServiceClient serviceClient;
    Builder() {
    }
    @Override
    public CommitterSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
      if (subscriptionPath == null) {
        throw new NullPointerException("Null subscriptionPath");
      }
      this.subscriptionPath = subscriptionPath;
      return this;
    }
    @Override
    public CommitterSettings.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public CommitterSettings.Builder setServiceClient(CursorServiceClient serviceClient) {
      if (serviceClient == null) {
        throw new NullPointerException("Null serviceClient");
      }
      this.serviceClient = serviceClient;
      return this;
    }
    @Override
    public CommitterSettings build() {
      if (this.subscriptionPath == null
          || this.partition == null
          || this.serviceClient == null) {
        StringBuilder missing = new StringBuilder();
        if (this.subscriptionPath == null) {
          missing.append(" subscriptionPath");
        }
        if (this.partition == null) {
          missing.append(" partition");
        }
        if (this.serviceClient == null) {
          missing.append(" serviceClient");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CommitterSettings(
          this.subscriptionPath,
          this.partition,
          this.serviceClient);
    }
  }

}
