/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Monitor;
import com.google.errorprone.annotations.concurrent.GuardedBy;

public abstract class SingleConnection<StreamRequestT, StreamResponseT, ClientResponseT>
implements ResponseObserver<StreamResponseT>,
AutoCloseable {
    private static final GoogleLogger log = GoogleLogger.forEnclosingClass();
    private final ClientStream<StreamRequestT> requestStream;
    private final ResponseObserver<ClientResponseT> clientStream;
    private final boolean expectInitial;
    private final CloseableMonitor connectionMonitor = new CloseableMonitor();
    @GuardedBy(value="connectionMonitor.monitor")
    private boolean receivedInitial = false;
    @GuardedBy(value="connectionMonitor.monitor")
    private boolean completed = false;

    protected abstract void handleInitialResponse(StreamResponseT var1) throws CheckedApiException;

    protected abstract void handleStreamResponse(StreamResponseT var1) throws CheckedApiException;

    protected SingleConnection(StreamFactory<StreamRequestT, StreamResponseT> streamFactory, ResponseObserver<ClientResponseT> clientStream, boolean expectInitialResponse) {
        this.clientStream = clientStream;
        this.requestStream = streamFactory.New(this);
        this.expectInitial = expectInitialResponse;
    }

    protected SingleConnection(StreamFactory<StreamRequestT, StreamResponseT> streamFactory, ResponseObserver<ClientResponseT> clientStream) {
        this(streamFactory, clientStream, true);
    }

    protected void initialize(StreamRequestT initialRequest) {
        this.requestStream.send(initialRequest);
        if (!this.expectInitial) {
            return;
        }
        CloseableMonitor.Hold h = this.connectionMonitor.enterWhenUninterruptibly(new Monitor.Guard(this.connectionMonitor.monitor){

            public boolean isSatisfied() {
                return SingleConnection.this.receivedInitial || SingleConnection.this.completed;
            }
        });
        Throwable throwable = null;
        if (h != null) {
            if (throwable != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                h.close();
            }
        }
    }

    protected void sendToStream(StreamRequestT request) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                ((GoogleLogger.Api)log.atFine()).log("Sent request after stream completion: %s", request);
                return;
            }
            Preconditions.checkState((boolean)this.receivedInitial);
            this.requestStream.send(request);
        }
    }

    protected void sendToClient(ClientResponseT response) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                ((GoogleLogger.Api)log.atFine()).log("Sent response after stream completion: %s", response);
                return;
            }
            Preconditions.checkState((boolean)this.receivedInitial);
        }
        this.clientStream.onResponse(response);
    }

    protected void setError(CheckedApiException error) {
        this.abort(error);
    }

    protected boolean isCompleted() {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            boolean bl = this.completed;
            return bl;
        }
    }

    @Override
    public void close() {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.requestStream.closeSend();
        this.clientStream.onComplete();
    }

    private void abort(CheckedApiException error) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.requestStream.closeSendWithError((Throwable)error.underlying);
        this.clientStream.onError((Throwable)error);
    }

    public void onStart(StreamController streamController) {
    }

    public void onResponse(StreamResponseT response) {
        boolean isFirst;
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                ((GoogleLogger.Api)log.atFine()).log("Received response on stream after completion: %s", response);
                return;
            }
            isFirst = !this.receivedInitial;
            this.receivedInitial = true;
        }
        try {
            if (isFirst) {
                this.handleInitialResponse(response);
            } else {
                this.handleStreamResponse(response);
            }
        }
        catch (CheckedApiException e) {
            this.abort(e);
        }
    }

    public void onError(Throwable t) {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.clientStream.onError(t);
        this.requestStream.closeSendWithError(t);
    }

    public void onComplete() {
        try (CloseableMonitor.Hold h = this.connectionMonitor.enter();){
            if (this.completed) {
                return;
            }
            this.completed = true;
        }
        this.clientStream.onComplete();
        this.requestStream.closeSend();
    }
}

