/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssigner;
import com.google.cloud.pubsublite.internal.wire.ConnectedAssignerFactory;
import com.google.cloud.pubsublite.internal.wire.SingleConnection;
import com.google.cloud.pubsublite.internal.wire.StreamFactory;
import com.google.cloud.pubsublite.proto.PartitionAssignment;
import com.google.cloud.pubsublite.proto.PartitionAssignmentAck;
import com.google.cloud.pubsublite.proto.PartitionAssignmentRequest;
import com.google.errorprone.annotations.concurrent.GuardedBy;

public class ConnectedAssignerImpl
extends SingleConnection<PartitionAssignmentRequest, PartitionAssignment, PartitionAssignment>
implements ConnectedAssigner {
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    boolean outstanding = false;

    private ConnectedAssignerImpl(StreamFactory<PartitionAssignmentRequest, PartitionAssignment> streamFactory, ResponseObserver<PartitionAssignment> clientStream, PartitionAssignmentRequest initialRequest) {
        super(streamFactory, clientStream, false);
        this.initialize(initialRequest);
    }

    @Override
    protected void handleInitialResponse(PartitionAssignment response) throws CheckedApiException {
        this.handleStreamResponse(response);
    }

    @Override
    protected void handleStreamResponse(PartitionAssignment response) throws CheckedApiException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            CheckedApiPreconditions.checkState(!this.outstanding, "Received assignment from the server while there was an assignment outstanding.");
            this.outstanding = true;
        }
        this.sendToClient(response);
    }

    @Override
    public void ack() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            CheckedApiPreconditions.checkState(this.outstanding, "Client acknowledged when there was no request outstanding.");
            this.outstanding = false;
        }
        catch (CheckedApiException e) {
            this.setError(e);
            throw e.underlying;
        }
        this.sendToStream(PartitionAssignmentRequest.newBuilder().setAck(PartitionAssignmentAck.getDefaultInstance()).build());
    }

    static class Factory
    implements ConnectedAssignerFactory {
        Factory() {
        }

        @Override
        public ConnectedAssigner New(StreamFactory<PartitionAssignmentRequest, PartitionAssignment> streamFactory, ResponseObserver<PartitionAssignment> clientStream, PartitionAssignmentRequest initialRequest) {
            return new ConnectedAssignerImpl(streamFactory, clientStream, initialRequest);
        }
    }
}

