/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.AbstractApiService;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.common.flogger.GoogleLogger;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class PartitionCountWatcherImpl
extends AbstractApiService
implements PartitionCountWatcher {
    private static final GoogleLogger log = GoogleLogger.forEnclosingClass();
    private final TopicPath topicPath;
    private final AdminClient adminClient;
    private final Consumer<Long> partitionCountReceiver;
    private final AlarmFactory alarmFactory;
    private Optional<Future<?>> partitionCountPoll = Optional.empty();
    private long currentPartitionCount = 0L;

    private PartitionCountWatcherImpl(TopicPath topicPath, AdminClient adminClient, AlarmFactory alarmFactory, Consumer<Long> receiver) {
        this.topicPath = topicPath;
        this.adminClient = adminClient;
        this.alarmFactory = alarmFactory;
        this.partitionCountReceiver = receiver;
    }

    private void onAlarm() {
        try {
            this.pollTopicConfig();
        }
        catch (Throwable t) {
            ((GoogleLogger.Api)((GoogleLogger.Api)log.atWarning()).withCause(t)).log("Failed to refresh partition count");
        }
    }

    private void pollTopicConfig() {
        try {
            long partitionCount = (Long)this.adminClient.getTopicPartitionCount(this.topicPath).get(1L, TimeUnit.MINUTES);
            if (this.currentPartitionCount == partitionCount) {
                return;
            }
            this.currentPartitionCount = partitionCount;
            this.partitionCountReceiver.accept(partitionCount);
        }
        catch (TimeoutException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)log.atWarning()).withCause((Throwable)e)).log("Timed out polling for partition count- see https://github.com/googleapis/gax-java/issues/1577");
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    protected void doStart() {
        this.pollTopicConfig();
        this.partitionCountPoll = Optional.of(this.alarmFactory.newAlarm(this::onAlarm));
        this.notifyStarted();
    }

    protected void doStop() {
        this.partitionCountPoll.ifPresent(future -> future.cancel(true));
        this.adminClient.close();
        this.notifyStopped();
    }

    public static class Factory
    implements PartitionCountWatcher.Factory {
        private final TopicPath topicPath;
        private final AdminClient adminClient;
        private final AlarmFactory alarmFactory;

        public Factory(TopicPath topicPath, AdminClient adminClient, AlarmFactory alarmFactory) {
            this.topicPath = topicPath;
            this.adminClient = adminClient;
            this.alarmFactory = alarmFactory;
        }

        @Override
        public PartitionCountWatcher newWatcher(Consumer<Long> receiver) {
            return new PartitionCountWatcherImpl(this.topicPath, this.adminClient, this.alarmFactory, receiver);
        }
    }
}

