/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.ErrorCodes;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.protobuf.Any;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.grpc.protobuf.StatusProto;

public final class ResetSignal {
    private static final String REASON = "RESET";
    private static final String DOMAIN = "pubsublite.googleapis.com";

    public static boolean isResetSignal(CheckedApiException checkedApiException) {
        if (!ErrorCodes.IsRetryableForStreams(checkedApiException.code())) {
            return false;
        }
        Status status = StatusProto.fromThrowable((Throwable)checkedApiException.underlying);
        if (status == null) {
            return false;
        }
        for (Any any : status.getDetailsList()) {
            if (!any.is(ErrorInfo.class)) continue;
            try {
                ErrorInfo errorInfo = (ErrorInfo)any.unpack(ErrorInfo.class);
                if (!REASON.equals(errorInfo.getReason()) || !DOMAIN.equals(errorInfo.getDomain())) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    private ResetSignal() {
    }
}

