/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberResetHandler;
import com.google.cloud.pubsublite.proto.SeekRequest;
import java.util.List;
import java.util.function.Consumer;

final class AutoValue_SubscriberBuilder
extends SubscriberBuilder {
    private final Consumer<List<SequencedMessage>> messageConsumer;
    private final SubscriptionPath subscriptionPath;
    private final Partition partition;
    private final StreamFactories.SubscribeStreamFactory streamFactory;
    private final SeekRequest initialLocation;
    private final SubscriberResetHandler resetHandler;
    private final boolean retryStreamRaces;

    private AutoValue_SubscriberBuilder(Consumer<List<SequencedMessage>> messageConsumer, SubscriptionPath subscriptionPath, Partition partition, StreamFactories.SubscribeStreamFactory streamFactory, SeekRequest initialLocation, SubscriberResetHandler resetHandler, boolean retryStreamRaces) {
        this.messageConsumer = messageConsumer;
        this.subscriptionPath = subscriptionPath;
        this.partition = partition;
        this.streamFactory = streamFactory;
        this.initialLocation = initialLocation;
        this.resetHandler = resetHandler;
        this.retryStreamRaces = retryStreamRaces;
    }

    @Override
    Consumer<List<SequencedMessage>> messageConsumer() {
        return this.messageConsumer;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    StreamFactories.SubscribeStreamFactory streamFactory() {
        return this.streamFactory;
    }

    @Override
    SeekRequest initialLocation() {
        return this.initialLocation;
    }

    @Override
    SubscriberResetHandler resetHandler() {
        return this.resetHandler;
    }

    @Override
    boolean retryStreamRaces() {
        return this.retryStreamRaces;
    }

    public String toString() {
        return "SubscriberBuilder{messageConsumer=" + this.messageConsumer + ", subscriptionPath=" + this.subscriptionPath + ", partition=" + this.partition + ", streamFactory=" + this.streamFactory + ", initialLocation=" + this.initialLocation + ", resetHandler=" + this.resetHandler + ", retryStreamRaces=" + this.retryStreamRaces + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberBuilder) {
            SubscriberBuilder that = (SubscriberBuilder)o;
            return this.messageConsumer.equals(that.messageConsumer()) && this.subscriptionPath.equals(that.subscriptionPath()) && this.partition.equals(that.partition()) && this.streamFactory.equals(that.streamFactory()) && this.initialLocation.equals((Object)that.initialLocation()) && this.resetHandler.equals(that.resetHandler()) && this.retryStreamRaces == that.retryStreamRaces();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.messageConsumer.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.streamFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialLocation.hashCode();
        h$ *= 1000003;
        h$ ^= this.resetHandler.hashCode();
        h$ *= 1000003;
        return h$ ^= this.retryStreamRaces ? 1231 : 1237;
    }

    static final class Builder
    extends SubscriberBuilder.Builder {
        private Consumer<List<SequencedMessage>> messageConsumer;
        private SubscriptionPath subscriptionPath;
        private Partition partition;
        private StreamFactories.SubscribeStreamFactory streamFactory;
        private SeekRequest initialLocation;
        private SubscriberResetHandler resetHandler;
        private Boolean retryStreamRaces;

        Builder() {
        }

        @Override
        public SubscriberBuilder.Builder setMessageConsumer(Consumer<List<SequencedMessage>> messageConsumer) {
            if (messageConsumer == null) {
                throw new NullPointerException("Null messageConsumer");
            }
            this.messageConsumer = messageConsumer;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setStreamFactory(StreamFactories.SubscribeStreamFactory streamFactory) {
            if (streamFactory == null) {
                throw new NullPointerException("Null streamFactory");
            }
            this.streamFactory = streamFactory;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setInitialLocation(SeekRequest initialLocation) {
            if (initialLocation == null) {
                throw new NullPointerException("Null initialLocation");
            }
            this.initialLocation = initialLocation;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setResetHandler(SubscriberResetHandler resetHandler) {
            if (resetHandler == null) {
                throw new NullPointerException("Null resetHandler");
            }
            this.resetHandler = resetHandler;
            return this;
        }

        @Override
        public SubscriberBuilder.Builder setRetryStreamRaces(boolean retryStreamRaces) {
            this.retryStreamRaces = retryStreamRaces;
            return this;
        }

        @Override
        SubscriberBuilder autoBuild() {
            if (this.messageConsumer == null || this.subscriptionPath == null || this.partition == null || this.streamFactory == null || this.initialLocation == null || this.resetHandler == null || this.retryStreamRaces == null) {
                StringBuilder missing = new StringBuilder();
                if (this.messageConsumer == null) {
                    missing.append(" messageConsumer");
                }
                if (this.subscriptionPath == null) {
                    missing.append(" subscriptionPath");
                }
                if (this.partition == null) {
                    missing.append(" partition");
                }
                if (this.streamFactory == null) {
                    missing.append(" streamFactory");
                }
                if (this.initialLocation == null) {
                    missing.append(" initialLocation");
                }
                if (this.resetHandler == null) {
                    missing.append(" resetHandler");
                }
                if (this.retryStreamRaces == null) {
                    missing.append(" retryStreamRaces");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberBuilder(this.messageConsumer, this.subscriptionPath, this.partition, this.streamFactory, this.initialLocation, this.resetHandler, this.retryStreamRaces);
        }
    }
}

