/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.auto.value.AutoOneOf;
import com.google.cloud.pubsublite.AutoOneOf_CloudRegionOrZone;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.CloudZone;
import java.io.Serializable;

@AutoOneOf(value=Kind.class)
public abstract class CloudRegionOrZone
implements Serializable {
    public abstract Kind getKind();

    public abstract CloudRegion region();

    public abstract CloudZone zone();

    public CloudRegion extractRegion() {
        switch (this.getKind()) {
            case REGION: {
                return this.region();
            }
            case ZONE: {
                return this.zone().region();
            }
        }
        throw new RuntimeException("Unknown case for CloudRegionOrZone.");
    }

    public static CloudRegionOrZone of(CloudRegion region) {
        return AutoOneOf_CloudRegionOrZone.region(region);
    }

    public static CloudRegionOrZone of(CloudZone zone) {
        return AutoOneOf_CloudRegionOrZone.zone(zone);
    }

    public static CloudRegionOrZone parse(String value) throws ApiException {
        try {
            return CloudRegionOrZone.of(CloudZone.parse(value));
        }
        catch (ApiException apiException) {
            return CloudRegionOrZone.of(CloudRegion.of(value));
        }
    }

    public String toString() {
        switch (this.getKind()) {
            case REGION: {
                return this.region().toString();
            }
            case ZONE: {
                return this.zone().toString();
            }
        }
        throw new RuntimeException("Unknown case for CloudRegionOrZone.");
    }

    public static enum Kind {
        REGION,
        ZONE;

    }
}

