/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.Lazy;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class SystemExecutors {
    private static final Lazy<ScheduledExecutorService> ALARM_EXECUTOR = new Lazy<ScheduledExecutorService>(() -> SystemExecutors.newDaemonExecutor("pubsub-lite-alarms"));
    private static final Lazy<Executor> FUTURES_EXECUTOR = new Lazy<Executor>(() -> SystemExecutors.newDaemonThreadPool("pubsub-lite-futures"));

    private SystemExecutors() {
    }

    private static ThreadFactory newDaemonThreadFactory(String prefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(prefix + "-%d").build();
    }

    public static ScheduledExecutorService newDaemonExecutor(String prefix) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Math.max(4, Runtime.getRuntime().availableProcessors()), SystemExecutors.newDaemonThreadFactory(prefix));
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static ScheduledExecutorService getAlarmExecutor() {
        return ALARM_EXECUTOR.get();
    }

    private static Executor newDaemonThreadPool(String prefix) {
        return Executors.newCachedThreadPool(SystemExecutors.newDaemonThreadFactory(prefix));
    }

    public static Executor getFuturesExecutor() {
        return FUTURES_EXECUTOR.get();
    }
}

