/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcesettings.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcesettings.v1.GetSettingRequest;
import com.google.cloud.resourcesettings.v1.ListSettingsRequest;
import com.google.cloud.resourcesettings.v1.ListSettingsResponse;
import com.google.cloud.resourcesettings.v1.ResourceSettingsServiceClient;
import com.google.cloud.resourcesettings.v1.Setting;
import com.google.cloud.resourcesettings.v1.UpdateSettingRequest;
import com.google.cloud.resourcesettings.v1.stub.GrpcResourceSettingsServiceCallableFactory;
import com.google.cloud.resourcesettings.v1.stub.ResourceSettingsServiceStub;
import com.google.cloud.resourcesettings.v1.stub.ResourceSettingsServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcResourceSettingsServiceStub
extends ResourceSettingsServiceStub {
    private static final MethodDescriptor<ListSettingsRequest, ListSettingsResponse> listSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcesettings.v1.ResourceSettingsService/ListSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSettingsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSettingRequest, Setting> getSettingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcesettings.v1.ResourceSettingsService/GetSetting").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSettingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Setting.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSettingRequest, Setting> updateSettingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcesettings.v1.ResourceSettingsService/UpdateSetting").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSettingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Setting.getDefaultInstance())).build();
    private final UnaryCallable<ListSettingsRequest, ListSettingsResponse> listSettingsCallable;
    private final UnaryCallable<ListSettingsRequest, ResourceSettingsServiceClient.ListSettingsPagedResponse> listSettingsPagedCallable;
    private final UnaryCallable<GetSettingRequest, Setting> getSettingCallable;
    private final UnaryCallable<UpdateSettingRequest, Setting> updateSettingCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcResourceSettingsServiceStub create(ResourceSettingsServiceStubSettings settings) throws IOException {
        return new GrpcResourceSettingsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcResourceSettingsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcResourceSettingsServiceStub(ResourceSettingsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcResourceSettingsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcResourceSettingsServiceStub(ResourceSettingsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcResourceSettingsServiceStub(ResourceSettingsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcResourceSettingsServiceCallableFactory());
    }

    protected GrpcResourceSettingsServiceStub(ResourceSettingsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSettingsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getSettingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSettingMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateSettingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSettingMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"setting.name", (Object)String.valueOf(request.getSetting().getName()));
            return params.build();
        }).build();
        this.listSettingsCallable = callableFactory.createUnaryCallable(listSettingsTransportSettings, settings.listSettingsSettings(), clientContext);
        this.listSettingsPagedCallable = callableFactory.createPagedCallable(listSettingsTransportSettings, settings.listSettingsSettings(), clientContext);
        this.getSettingCallable = callableFactory.createUnaryCallable(getSettingTransportSettings, settings.getSettingSettings(), clientContext);
        this.updateSettingCallable = callableFactory.createUnaryCallable(updateSettingTransportSettings, settings.updateSettingSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListSettingsRequest, ListSettingsResponse> listSettingsCallable() {
        return this.listSettingsCallable;
    }

    @Override
    public UnaryCallable<ListSettingsRequest, ResourceSettingsServiceClient.ListSettingsPagedResponse> listSettingsPagedCallable() {
        return this.listSettingsPagedCallable;
    }

    @Override
    public UnaryCallable<GetSettingRequest, Setting> getSettingCallable() {
        return this.getSettingCallable;
    }

    @Override
    public UnaryCallable<UpdateSettingRequest, Setting> updateSettingCallable() {
        return this.updateSettingCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

