/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcesettings.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcesettings.v1.GetSettingRequest;
import com.google.cloud.resourcesettings.v1.ListSettingsRequest;
import com.google.cloud.resourcesettings.v1.ListSettingsResponse;
import com.google.cloud.resourcesettings.v1.ResourceSettingsServiceClient;
import com.google.cloud.resourcesettings.v1.Setting;
import com.google.cloud.resourcesettings.v1.UpdateSettingRequest;
import com.google.cloud.resourcesettings.v1.stub.HttpJsonResourceSettingsServiceCallableFactory;
import com.google.cloud.resourcesettings.v1.stub.ResourceSettingsServiceStub;
import com.google.cloud.resourcesettings.v1.stub.ResourceSettingsServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonResourceSettingsServiceStub
extends ResourceSettingsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListSettingsRequest, ListSettingsResponse> listSettingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcesettings.v1.ResourceSettingsService/ListSettings").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*}/settings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*}/settings", "/v1/{parent=projects/*}/settings"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSettingsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSettingRequest, Setting> getSettingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcesettings.v1.ResourceSettingsService/GetSetting").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/settings/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=folders/*/settings/*}", "/v1/{name=projects/*/settings/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Setting.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSettingRequest, Setting> updateSettingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.resourcesettings.v1.ResourceSettingsService/UpdateSetting").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{setting.name=organizations/*/settings/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "setting.name", (Object)request.getSetting().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{setting.name=folders/*/settings/*}", "/v1/{setting.name=projects/*/settings/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("setting", (Message)request.getSetting(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Setting.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListSettingsRequest, ListSettingsResponse> listSettingsCallable;
    private final UnaryCallable<ListSettingsRequest, ResourceSettingsServiceClient.ListSettingsPagedResponse> listSettingsPagedCallable;
    private final UnaryCallable<GetSettingRequest, Setting> getSettingCallable;
    private final UnaryCallable<UpdateSettingRequest, Setting> updateSettingCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonResourceSettingsServiceStub create(ResourceSettingsServiceStubSettings settings) throws IOException {
        return new HttpJsonResourceSettingsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonResourceSettingsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonResourceSettingsServiceStub(ResourceSettingsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonResourceSettingsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonResourceSettingsServiceStub(ResourceSettingsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonResourceSettingsServiceStub(ResourceSettingsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonResourceSettingsServiceCallableFactory());
    }

    protected HttpJsonResourceSettingsServiceStub(ResourceSettingsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listSettingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSettingsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSettingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSettingMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSettingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSettingMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("setting.name", String.valueOf(request.getSetting().getName()));
            return builder.build();
        }).build();
        this.listSettingsCallable = callableFactory.createUnaryCallable(listSettingsTransportSettings, settings.listSettingsSettings(), clientContext);
        this.listSettingsPagedCallable = callableFactory.createPagedCallable(listSettingsTransportSettings, settings.listSettingsSettings(), clientContext);
        this.getSettingCallable = callableFactory.createUnaryCallable(getSettingTransportSettings, settings.getSettingSettings(), clientContext);
        this.updateSettingCallable = callableFactory.createUnaryCallable(updateSettingTransportSettings, settings.updateSettingSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listSettingsMethodDescriptor);
        methodDescriptors.add(getSettingMethodDescriptor);
        methodDescriptors.add(updateSettingMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListSettingsRequest, ListSettingsResponse> listSettingsCallable() {
        return this.listSettingsCallable;
    }

    @Override
    public UnaryCallable<ListSettingsRequest, ResourceSettingsServiceClient.ListSettingsPagedResponse> listSettingsPagedCallable() {
        return this.listSettingsPagedCallable;
    }

    @Override
    public UnaryCallable<GetSettingRequest, Setting> getSettingCallable() {
        return this.getSettingCallable;
    }

    @Override
    public UnaryCallable<UpdateSettingRequest, Setting> updateSettingCallable() {
        return this.updateSettingCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

