/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.cloud.retail.v2beta.ConversationalSearchRequest;
import com.google.cloud.retail.v2beta.ConversationalSearchResponse;
import com.google.cloud.retail.v2beta.stub.ConversationalSearchServiceStub;
import com.google.cloud.retail.v2beta.stub.ConversationalSearchServiceStubSettings;
import com.google.cloud.retail.v2beta.stub.GrpcConversationalSearchServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConversationalSearchServiceStub
extends ConversationalSearchServiceStub {
    private static final MethodDescriptor<ConversationalSearchRequest, ConversationalSearchResponse> conversationalSearchMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.retail.v2beta.ConversationalSearchService/ConversationalSearch").setRequestMarshaller(ProtoUtils.marshaller((Message)ConversationalSearchRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ConversationalSearchResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final ServerStreamingCallable<ConversationalSearchRequest, ConversationalSearchResponse> conversationalSearchCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationalSearchServiceStub create(ConversationalSearchServiceStubSettings settings) throws IOException {
        return new GrpcConversationalSearchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationalSearchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationalSearchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationalSearchServiceCallableFactory());
    }

    protected GrpcConversationalSearchServiceStub(ConversationalSearchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings conversationalSearchTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(conversationalSearchMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("placement", String.valueOf(request.getPlacement()));
            return builder.build();
        }).build();
        this.conversationalSearchCallable = callableFactory.createServerStreamingCallable(conversationalSearchTransportSettings, settings.conversationalSearchSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public ServerStreamingCallable<ConversationalSearchRequest, ConversationalSearchResponse> conversationalSearchCallable() {
        return this.conversationalSearchCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

