/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.scheduler.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.scheduler.v1beta1.CloudSchedulerSettings;
import com.google.cloud.scheduler.v1beta1.CreateJobRequest;
import com.google.cloud.scheduler.v1beta1.DeleteJobRequest;
import com.google.cloud.scheduler.v1beta1.GetJobRequest;
import com.google.cloud.scheduler.v1beta1.Job;
import com.google.cloud.scheduler.v1beta1.JobName;
import com.google.cloud.scheduler.v1beta1.ListJobsRequest;
import com.google.cloud.scheduler.v1beta1.ListJobsResponse;
import com.google.cloud.scheduler.v1beta1.LocationName;
import com.google.cloud.scheduler.v1beta1.PauseJobRequest;
import com.google.cloud.scheduler.v1beta1.ResumeJobRequest;
import com.google.cloud.scheduler.v1beta1.RunJobRequest;
import com.google.cloud.scheduler.v1beta1.UpdateJobRequest;
import com.google.cloud.scheduler.v1beta1.stub.CloudSchedulerStub;
import com.google.cloud.scheduler.v1beta1.stub.CloudSchedulerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudSchedulerClient
implements BackgroundResource {
    private final CloudSchedulerSettings settings;
    private final CloudSchedulerStub stub;

    public static final CloudSchedulerClient create() throws IOException {
        return CloudSchedulerClient.create(CloudSchedulerSettings.newBuilder().build());
    }

    public static final CloudSchedulerClient create(CloudSchedulerSettings settings) throws IOException {
        return new CloudSchedulerClient(settings);
    }

    public static final CloudSchedulerClient create(CloudSchedulerStub stub) {
        return new CloudSchedulerClient(stub);
    }

    protected CloudSchedulerClient(CloudSchedulerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudSchedulerStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudSchedulerClient(CloudSchedulerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudSchedulerSettings getSettings() {
        return this.settings;
    }

    public CloudSchedulerStub getStub() {
        return this.stub;
    }

    public final ListJobsPagedResponse listJobs(LocationName parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(String parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Job getJob(JobName name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJob(request);
    }

    public final Job getJob(String name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final Job createJob(LocationName parent, Job job) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJob(job).build();
        return this.createJob(request);
    }

    public final Job createJob(String parent, Job job) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent).setJob(job).build();
        return this.createJob(request);
    }

    public final Job createJob(CreateJobRequest request) {
        return (Job)this.createJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.stub.createJobCallable();
    }

    public final Job updateJob(Job job, FieldMask updateMask) {
        UpdateJobRequest request = UpdateJobRequest.newBuilder().setJob(job).setUpdateMask(updateMask).build();
        return this.updateJob(request);
    }

    public final Job updateJob(UpdateJobRequest request) {
        return (Job)this.updateJobCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.stub.updateJobCallable();
    }

    public final void deleteJob(JobName name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteJob(request);
    }

    public final void deleteJob(String name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name).build();
        this.deleteJob(request);
    }

    public final void deleteJob(DeleteJobRequest request) {
        this.deleteJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final Job pauseJob(JobName name) {
        PauseJobRequest request = PauseJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseJob(request);
    }

    public final Job pauseJob(String name) {
        PauseJobRequest request = PauseJobRequest.newBuilder().setName(name).build();
        return this.pauseJob(request);
    }

    public final Job pauseJob(PauseJobRequest request) {
        return (Job)this.pauseJobCallable().call((Object)request);
    }

    public final UnaryCallable<PauseJobRequest, Job> pauseJobCallable() {
        return this.stub.pauseJobCallable();
    }

    public final Job resumeJob(JobName name) {
        ResumeJobRequest request = ResumeJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumeJob(request);
    }

    public final Job resumeJob(String name) {
        ResumeJobRequest request = ResumeJobRequest.newBuilder().setName(name).build();
        return this.resumeJob(request);
    }

    public final Job resumeJob(ResumeJobRequest request) {
        return (Job)this.resumeJobCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeJobRequest, Job> resumeJobCallable() {
        return this.stub.resumeJobCallable();
    }

    public final Job runJob(JobName name) {
        RunJobRequest request = RunJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runJob(request);
    }

    public final Job runJob(String name) {
        RunJobRequest request = RunJobRequest.newBuilder().setName(name).build();
        return this.runJob(request);
    }

    public final Job runJob(RunJobRequest request) {
        return (Job)this.runJobCallable().call((Object)request);
    }

    public final UnaryCallable<RunJobRequest, Job> runJobCallable() {
        return this.stub.runJobCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobsPagedResponse((ListJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

