/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.executor.spanner;

import com.google.cloud.executor.spanner.CloudClientExecutor;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.spanner.executor.v1.SpannerAsyncActionRequest;
import com.google.spanner.executor.v1.SpannerAsyncActionResponse;
import com.google.spanner.executor.v1.SpannerExecutorProxyGrpc;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudExecutorImpl
extends SpannerExecutorProxyGrpc.SpannerExecutorProxyImplBase {
    private static final Logger LOGGER = Logger.getLogger(CloudExecutorImpl.class.getName());
    private final CloudClientExecutor clientExecutor;

    public CloudExecutorImpl(boolean enableGrpcFaultInjector) {
        this.clientExecutor = new CloudClientExecutor(enableGrpcFaultInjector);
    }

    public StreamObserver<SpannerAsyncActionRequest> executeActionAsync(final StreamObserver<SpannerAsyncActionResponse> responseObserver) {
        CloudClientExecutor cloudClientExecutor = this.clientExecutor;
        Objects.requireNonNull(cloudClientExecutor);
        final CloudClientExecutor.ExecutionFlowContext executionContext = new CloudClientExecutor.ExecutionFlowContext(cloudClientExecutor, responseObserver);
        return new StreamObserver<SpannerAsyncActionRequest>(){

            public void onNext(SpannerAsyncActionRequest request) {
                LOGGER.log(Level.INFO, String.format("Receiving request: \n%s", request));
                Status status = CloudExecutorImpl.this.clientExecutor.startHandlingRequest(request, executionContext);
                if (!status.isOk()) {
                    LOGGER.log(Level.WARNING, "Failed to handle request, half closed", SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)status.getDescription()));
                }
            }

            public void onError(Throwable t) {
                LOGGER.log(Level.WARNING, "Client ends the stream with error.", t);
                executionContext.cleanup();
            }

            public void onCompleted() {
                LOGGER.log(Level.INFO, "Client called Done, half closed");
                executionContext.cleanup();
                responseObserver.onCompleted();
            }
        };
    }
}

