/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.executor.spanner;

import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.executor.spanner.WorkerProxy;
import com.google.common.net.HostAndPort;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;

public class CloudUtil {
    private static final int GRPC_MAX_HEADER_LIST_SIZE_BYTES = 0xA00000;
    private static final String TEST_HOST_IN_CERT = "test-cert-2";

    public static TransportChannelProvider newChannelProviderHelper(int port) {
        NettyChannelBuilder builder = (NettyChannelBuilder)CloudUtil.getChannelBuilderForTestGFE("localhost", port, WorkerProxy.cert, TEST_HOST_IN_CERT).maxInboundMessageSize(0x6400000);
        if (WorkerProxy.usePlainTextChannel) {
            builder.usePlaintext();
        }
        GrpcTransportChannel channel = GrpcTransportChannel.newBuilder().setManagedChannel(builder.maxInboundMetadataSize(0xA00000).build()).build();
        return FixedTransportChannelProvider.create((TransportChannel)channel);
    }

    public static ManagedChannelBuilder<?> getChannelBuilderForTestGFE(String host, int sslPort, String certPath, String hostInCert) {
        String target;
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().trustManager(CertUtil.copyCert(certPath)).ciphers(null).build();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        HostAndPort hostPort = HostAndPort.fromParts((String)host, (int)sslPort);
        try {
            target = new URI("dns", "", "/" + hostPort, null).toString();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        try {
            NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)target);
            InternalNettyChannelBuilder.disableCheckAuthority((NettyChannelBuilder)channelBuilder);
            return ((NettyChannelBuilder)channelBuilder.overrideAuthority(hostInCert)).sslContext(sslContext).negotiationType(NegotiationType.TLS);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static final class CertUtil {
        private CertUtil() {
        }

        public static File copyCert(String certFileName) throws IOException {
            File certFile = new File(certFileName);
            File file = File.createTempFile("CAcert", "pem");
            file.deleteOnExit();
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(certFile), StandardCharsets.UTF_8));
                 OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                while (true) {
                    String line;
                    if ((line = in.readLine()) != null && !"-----BEGIN CERTIFICATE-----".equals(line)) {
                        continue;
                    }
                    ((Writer)out).append(line);
                    ((Writer)out).append("\n");
                    while ((line = in.readLine()) != null) {
                        ((Writer)out).append(line);
                        ((Writer)out).append("\n");
                        if (!"-----END CERTIFICATE-----".equals(line)) continue;
                    }
                    if (line == null) break;
                }
            }
            return file;
        }
    }
}

