/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.executor.spanner;

import com.google.cloud.executor.spanner.CloudExecutorImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.protobuf.services.HealthStatusManager;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class WorkerProxy {
    private static final Logger LOGGER = Logger.getLogger(WorkerProxy.class.getName());
    private static final String OPTION_SPANNER_PORT = "spanner_port";
    private static final String OPTION_PROXY_PORT = "proxy_port";
    private static final String OPTION_CERTIFICATE = "cert";
    private static final String OPTION_SERVICE_KEY_FILE = "service_key_file";
    private static final String OPTION_USE_PLAIN_TEXT_CHANNEL = "use_plain_text_channel";
    private static final String OPTION_ENABLE_GRPC_FAULT_INJECTOR = "enable_grpc_fault_injector";
    public static int spannerPort = 0;
    public static int proxyPort = 0;
    public static String cert = "";
    public static String serviceKeyFile = "";
    public static boolean usePlainTextChannel = false;
    public static boolean enableGrpcFaultInjector = false;
    public static CommandLine commandLine;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;

    public static void main(String[] args) throws Exception {
        Server server;
        commandLine = WorkerProxy.buildOptions(args);
        if (!commandLine.hasOption(OPTION_SPANNER_PORT)) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Spanner proxyPort need to be assigned in order to start worker proxy.");
        }
        spannerPort = Integer.parseInt(commandLine.getOptionValue(OPTION_SPANNER_PORT));
        if (spannerPort < 0 || spannerPort > 65535) {
            throw new IllegalArgumentException("Spanner proxyPort must be between 0 and 65535");
        }
        if (!commandLine.hasOption(OPTION_PROXY_PORT)) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Proxy port need to be assigned in order to start worker proxy.");
        }
        proxyPort = Integer.parseInt(commandLine.getOptionValue(OPTION_PROXY_PORT));
        if (proxyPort < 0 || proxyPort > 65535) {
            throw new IllegalArgumentException("Proxy port must be between 0 and 65535");
        }
        if (!commandLine.hasOption(OPTION_CERTIFICATE)) {
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)"Certificate need to be assigned in order to start worker proxy.");
        }
        cert = commandLine.getOptionValue(OPTION_CERTIFICATE);
        if (commandLine.hasOption(OPTION_SERVICE_KEY_FILE)) {
            serviceKeyFile = commandLine.getOptionValue(OPTION_SERVICE_KEY_FILE);
        }
        usePlainTextChannel = commandLine.hasOption(OPTION_USE_PLAIN_TEXT_CHANNEL);
        enableGrpcFaultInjector = commandLine.hasOption(OPTION_ENABLE_GRPC_FAULT_INJECTOR);
        while (true) {
            try {
                CloudExecutorImpl cloudExecutorImpl = new CloudExecutorImpl(enableGrpcFaultInjector);
                HealthStatusManager healthStatusManager = new HealthStatusManager();
                server = ServerBuilder.forPort((int)proxyPort).addService((BindableService)cloudExecutorImpl).addService(ProtoReflectionService.newInstance()).addService(healthStatusManager.getHealthService()).build();
                server.start();
                LOGGER.log(Level.INFO, String.format("Server started on proxyPort: %d", proxyPort));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, String.format("Failed to start server on proxyPort %d", proxyPort), e);
                continue;
            }
            break;
        }
        server.awaitTermination();
    }

    private static CommandLine buildOptions(String[] args) {
        Options options = new Options();
        options.addOption(null, OPTION_SPANNER_PORT, true, "Port of Spanner Frontend to which to send requests.");
        options.addOption(null, OPTION_PROXY_PORT, true, "Proxy port to start worker proxy on.");
        options.addOption(null, OPTION_CERTIFICATE, true, "Certificate used to connect to Spanner GFE.");
        options.addOption(null, OPTION_SERVICE_KEY_FILE, true, "Service key file used to set authentication.");
        options.addOption(null, OPTION_USE_PLAIN_TEXT_CHANNEL, false, "Use a plain text gRPC channel (intended for the Cloud Spanner Emulator).");
        options.addOption(null, OPTION_ENABLE_GRPC_FAULT_INJECTOR, false, "Enable grpc fault injector in cloud client executor.");
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

