/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate;

import com.google.cloud.spanner.hibernate.SpannerTableExporter;
import com.google.cloud.spanner.hibernate.SpannerUniqueDelegate;
import com.google.cloud.spanner.hibernate.schema.SpannerForeignKeyExporter;
import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class SpannerDialect
extends Dialect {
    private static final int STRING_MAX_LENGTH = 0x280000;
    private static final int BYTES_MAX_LENGTH = 0xA00000;
    private final SpannerTableExporter spannerTableExporter = new SpannerTableExporter(this);
    private final SpannerForeignKeyExporter spannerForeignKeyExporter = new SpannerForeignKeyExporter(this);
    private static final LockingStrategy LOCKING_STRATEGY = new DoNothingLockingStrategy();
    private static final Exporter NOOP_EXPORTER = new EmptyExporter();
    private final UniqueDelegate uniqueDelegate;

    public SpannerDialect() {
        this.registerColumnType(2003, "ARRAY");
        this.registerColumnType(16, "BOOL");
        this.registerColumnType(-7, "BOOL");
        this.registerColumnType(-5, "INT64");
        this.registerColumnType(5, "INT64");
        this.registerColumnType(-6, "INT64");
        this.registerColumnType(4, "INT64");
        this.registerColumnType(1, "STRING(1)");
        this.registerColumnType(12, 0x280000L, "STRING($l)");
        this.registerColumnType(-9, 0x280000L, "STRING($l)");
        this.registerColumnType(6, "FLOAT64");
        this.registerColumnType(8, "FLOAT64");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIMESTAMP");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, 0xA00000L, "BYTES($l)");
        this.registerColumnType(-2, 0xA00000L, "BYTES($l)");
        this.registerColumnType(-1, 0x280000L, "STRING($l)");
        this.registerColumnType(-4, 0xA00000L, "BYTES($l)");
        this.registerColumnType(2005, "STRING(MAX)");
        this.registerColumnType(2011, "STRING(MAX)");
        this.registerColumnType(2004, "BYTES(MAX)");
        this.registerColumnType(100011, "JSON");
        this.registerColumnType(3, "NUMERIC");
        this.registerColumnType(2, "NUMERIC");
        this.registerFunction("ANY_VALUE", (SQLFunction)new StandardSQLFunction("ANY_VALUE"));
        this.registerFunction("COUNTIF", (SQLFunction)new StandardSQLFunction("COUNTIF", (Type)StandardBasicTypes.LONG));
        this.registerFunction("CONCAT", (SQLFunction)new StandardSQLFunction("CONCAT"));
        this.registerFunction("STRING_AGG", (SQLFunction)new StandardSQLFunction("STRING_AGG", (Type)StandardBasicTypes.STRING));
        this.registerFunction("FARM_FINGERPRINT", (SQLFunction)new StandardSQLFunction("FARM_FINGERPRINT", (Type)StandardBasicTypes.LONG));
        this.registerFunction("SHA1", (SQLFunction)new StandardSQLFunction("SHA1", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("SHA256", (SQLFunction)new StandardSQLFunction("SHA256", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("SHA512", (SQLFunction)new StandardSQLFunction("SHA512", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("BYTE_LENGTH", (SQLFunction)new StandardSQLFunction("BYTE_LENGTH", (Type)StandardBasicTypes.LONG));
        this.registerFunction("CHAR_LENGTH", (SQLFunction)new StandardSQLFunction("CHAR_LENGTH", (Type)StandardBasicTypes.LONG));
        this.registerFunction("CHARACTER_LENGTH", (SQLFunction)new StandardSQLFunction("CHARACTER_LENGTH", (Type)StandardBasicTypes.LONG));
        this.registerFunction("CODE_POINTS_TO_BYTES", (SQLFunction)new StandardSQLFunction("CODE_POINTS_TO_BYTES", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("CODE_POINTS_TO_STRING", (SQLFunction)new StandardSQLFunction("CODE_POINTS_TO_STRING", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ENDS_WITH", (SQLFunction)new StandardSQLFunction("ENDS_WITH", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("FORMAT", (SQLFunction)new StandardSQLFunction("FORMAT", (Type)StandardBasicTypes.STRING));
        this.registerFunction("FROM_BASE64", (SQLFunction)new StandardSQLFunction("FROM_BASE64", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("FROM_HEX", (SQLFunction)new StandardSQLFunction("FROM_HEX", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("LENGTH", (SQLFunction)new StandardSQLFunction("LENGTH", (Type)StandardBasicTypes.LONG));
        this.registerFunction("LPAD", (SQLFunction)new StandardSQLFunction("LPAD"));
        this.registerFunction("LOCATE", (SQLFunction)new StandardSQLFunction("STRPOS", (Type)StandardBasicTypes.LONG));
        this.registerFunction("LOWER", (SQLFunction)new StandardSQLFunction("LOWER"));
        this.registerFunction("LTRIM", (SQLFunction)new StandardSQLFunction("LTRIM"));
        this.registerFunction("REGEXP_CONTAINS", (SQLFunction)new StandardSQLFunction("REGEXP_CONTAINS", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("REGEXP_EXTRACT", (SQLFunction)new StandardSQLFunction("REGEXP_EXTRACT"));
        this.registerFunction("REGEXP_REPLACE", (SQLFunction)new StandardSQLFunction("REGEXP_REPLACE"));
        this.registerFunction("REPLACE", (SQLFunction)new StandardSQLFunction("REPLACE"));
        this.registerFunction("REPEAT", (SQLFunction)new StandardSQLFunction("REPEAT"));
        this.registerFunction("REVERSE", (SQLFunction)new StandardSQLFunction("REVERSE"));
        this.registerFunction("RPAD", (SQLFunction)new StandardSQLFunction("RPAD"));
        this.registerFunction("RTRIM", (SQLFunction)new StandardSQLFunction("RTRIM"));
        this.registerFunction("SAFE_CONVERT_BYTES_TO_STRING", (SQLFunction)new StandardSQLFunction("SAFE_CONVERT_BYTES_TO_STRING", (Type)StandardBasicTypes.STRING));
        this.registerFunction("STARTS_WITH", (SQLFunction)new StandardSQLFunction("STARTS_WITH", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("STR", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "cast(?1 as string)"));
        this.registerFunction("STRPOS", (SQLFunction)new StandardSQLFunction("STRPOS", (Type)StandardBasicTypes.LONG));
        this.registerFunction("SUBSTR", (SQLFunction)new StandardSQLFunction("SUBSTR", (Type)StandardBasicTypes.STRING));
        this.registerFunction("SUBSTRING", (SQLFunction)new StandardSQLFunction("SUBSTR", (Type)StandardBasicTypes.STRING));
        this.registerFunction("TO_BASE64", (SQLFunction)new StandardSQLFunction("TO_BASE64", (Type)StandardBasicTypes.STRING));
        this.registerFunction("TO_HEX", (SQLFunction)new StandardSQLFunction("TO_HEX", (Type)StandardBasicTypes.STRING));
        this.registerFunction("TRIM", (SQLFunction)new StandardSQLFunction("TRIM"));
        this.registerFunction("UPPER", (SQLFunction)new StandardSQLFunction("UPPER"));
        this.registerFunction("JSON_QUERY", (SQLFunction)new StandardSQLFunction("JSON_QUERY", (Type)StandardBasicTypes.STRING));
        this.registerFunction("JSON_VALUE", (SQLFunction)new StandardSQLFunction("JSON_VALUE", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ARRAY_CONCAT", (SQLFunction)new StandardSQLFunction("ARRAY_CONCAT"));
        this.registerFunction("ARRAY_LENGTH", (SQLFunction)new StandardSQLFunction("ARRAY_LENGTH", (Type)StandardBasicTypes.LONG));
        this.registerFunction("ARRAY_TO_STRING", (SQLFunction)new StandardSQLFunction("ARRAY_TO_STRING", (Type)StandardBasicTypes.STRING));
        this.registerFunction("ARRAY_REVERSE", (SQLFunction)new StandardSQLFunction("ARRAY_REVERSE"));
        this.registerFunction("CURRENT_DATE", (SQLFunction)new StandardSQLFunction("CURRENT_DATE", (Type)StandardBasicTypes.DATE));
        this.registerFunction("EXTRACT", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "extract(?1 ?2 ?3)"));
        this.registerFunction("DATE", (SQLFunction)new StandardSQLFunction("DATE", (Type)StandardBasicTypes.DATE));
        this.registerFunction("DATE_ADD", (SQLFunction)new StandardSQLFunction("DATE_ADD", (Type)StandardBasicTypes.DATE));
        this.registerFunction("DATE_SUB", (SQLFunction)new StandardSQLFunction("DATE_SUB", (Type)StandardBasicTypes.DATE));
        this.registerFunction("DATE_DIFF", (SQLFunction)new StandardSQLFunction("DATE_DIFF", (Type)StandardBasicTypes.LONG));
        this.registerFunction("DATE_TRUNC", (SQLFunction)new StandardSQLFunction("DATE_TRUNC", (Type)StandardBasicTypes.DATE));
        this.registerFunction("DATE_FROM_UNIX_DATE", (SQLFunction)new StandardSQLFunction("DATE_FROM_UNIX_DATE", (Type)StandardBasicTypes.DATE));
        this.registerFunction("FORMAT_DATE", (SQLFunction)new StandardSQLFunction("FORMAT_DATE", (Type)StandardBasicTypes.STRING));
        this.registerFunction("PARSE_DATE", (SQLFunction)new StandardSQLFunction("PARSE_DATE", (Type)StandardBasicTypes.DATE));
        this.registerFunction("UNIX_DATE", (SQLFunction)new StandardSQLFunction("UNIX_DATE", (Type)StandardBasicTypes.LONG));
        this.registerFunction("CURRENT_TIME", (SQLFunction)new StandardSQLFunction("CURRENT_TIMESTAMP", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("CURRENT_TIMESTAMP", (SQLFunction)new StandardSQLFunction("CURRENT_TIMESTAMP", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("STRING", (SQLFunction)new StandardSQLFunction("STRING", (Type)StandardBasicTypes.STRING));
        this.registerFunction("TIMESTAMP", (SQLFunction)new StandardSQLFunction("TIMESTAMP", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("TIMESTAMP_ADD", (SQLFunction)new StandardSQLFunction("TIMESTAMP_ADD", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("TIMESTAMP_SUB", (SQLFunction)new StandardSQLFunction("TIMESTAMP_SUB", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("TIMESTAMP_DIFF", (SQLFunction)new StandardSQLFunction("TIMESTAMP_DIFF", (Type)StandardBasicTypes.LONG));
        this.registerFunction("TIMESTAMP_TRUNC", (SQLFunction)new StandardSQLFunction("TIMESTAMP_TRUNC", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("FORMAT_TIMESTAMP", (SQLFunction)new StandardSQLFunction("FORMAT_TIMESTAMP", (Type)StandardBasicTypes.STRING));
        this.registerFunction("PARSE_TIMESTAMP", (SQLFunction)new StandardSQLFunction("PARSE_TIMESTAMP", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("TIMESTAMP_SECONDS", (SQLFunction)new StandardSQLFunction("TIMESTAMP_SECONDS", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("TIMESTAMP_MILLIS", (SQLFunction)new StandardSQLFunction("TIMESTAMP_MILLIS", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("TIMESTAMP_MICROS", (SQLFunction)new StandardSQLFunction("TIMESTAMP_MICROS", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("UNIX_SECONDS", (SQLFunction)new StandardSQLFunction("UNIX_SECONDS", (Type)StandardBasicTypes.LONG));
        this.registerFunction("UNIX_MILLIS", (SQLFunction)new StandardSQLFunction("UNIX_MILLIS", (Type)StandardBasicTypes.LONG));
        this.registerFunction("UNIX_MICROS", (SQLFunction)new StandardSQLFunction("UNIX_MICROS", (Type)StandardBasicTypes.LONG));
        this.registerFunction("PARSE_TIMESTAMP", (SQLFunction)new StandardSQLFunction("PARSE_TIMESTAMP", (Type)StandardBasicTypes.TIMESTAMP));
        this.registerFunction("BIT_AND", (SQLFunction)new StandardSQLFunction("BIT_AND", (Type)StandardBasicTypes.LONG));
        this.registerFunction("BIT_OR", (SQLFunction)new StandardSQLFunction("BIT_OR", (Type)StandardBasicTypes.LONG));
        this.registerFunction("BIT_XOR", (SQLFunction)new StandardSQLFunction("BIT_XOR", (Type)StandardBasicTypes.LONG));
        this.registerFunction("LOGICAL_AND", (SQLFunction)new StandardSQLFunction("LOGICAL_AND", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("LOGICAL_OR", (SQLFunction)new StandardSQLFunction("LOGICAL_OR", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IS_INF", (SQLFunction)new StandardSQLFunction("IS_INF", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("IS_NAN", (SQLFunction)new StandardSQLFunction("IS_NAN", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("SIGN", (SQLFunction)new StandardSQLFunction("SIGN"));
        this.registerFunction("IEEE_DIVIDE", (SQLFunction)new StandardSQLFunction("IEEE_DIVIDE", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("SQRT", (SQLFunction)new StandardSQLFunction("SQRT", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("POW", (SQLFunction)new StandardSQLFunction("POW", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("POWER", (SQLFunction)new StandardSQLFunction("POWER", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("EXP", (SQLFunction)new StandardSQLFunction("EXP", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LN", (SQLFunction)new StandardSQLFunction("LN", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LOG", (SQLFunction)new StandardSQLFunction("LOG", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("LOG10", (SQLFunction)new StandardSQLFunction("LOG10", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST"));
        this.registerFunction("LEAST", (SQLFunction)new StandardSQLFunction("LEAST"));
        this.registerFunction("DIV", (SQLFunction)new StandardSQLFunction("DIV", (Type)StandardBasicTypes.LONG));
        this.registerFunction("MOD", (SQLFunction)new StandardSQLFunction("MOD", (Type)StandardBasicTypes.LONG));
        this.registerFunction("ROUND", (SQLFunction)new StandardSQLFunction("ROUND", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("TRUNC", (SQLFunction)new StandardSQLFunction("TRUNC", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("CEIL", (SQLFunction)new StandardSQLFunction("CEIL", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("CEILING", (SQLFunction)new StandardSQLFunction("CEILING", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("FLOOR", (SQLFunction)new StandardSQLFunction("FLOOR", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("COS", (SQLFunction)new StandardSQLFunction("COS", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("COSH", (SQLFunction)new StandardSQLFunction("COSH", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ACOS", (SQLFunction)new StandardSQLFunction("ACOS", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ACOSH", (SQLFunction)new StandardSQLFunction("ACOSH", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("SIN", (SQLFunction)new StandardSQLFunction("SIN", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("SINH", (SQLFunction)new StandardSQLFunction("SINH", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ASIN", (SQLFunction)new StandardSQLFunction("ASIN", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ASINH", (SQLFunction)new StandardSQLFunction("ASINH", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("TAN", (SQLFunction)new StandardSQLFunction("TAN", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("TANH", (SQLFunction)new StandardSQLFunction("TANH", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ATAN", (SQLFunction)new StandardSQLFunction("ATAN", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ATANH", (SQLFunction)new StandardSQLFunction("ATANH", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("ATAN2", (SQLFunction)new StandardSQLFunction("ATAN2", (Type)StandardBasicTypes.DOUBLE));
        this.uniqueDelegate = new SpannerUniqueDelegate(this);
    }

    public Exporter<Table> getTableExporter() {
        return this.spannerTableExporter;
    }

    public Exporter<ForeignKey> getForeignKeyExporter() {
        return this.spannerForeignKeyExporter;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "SELECT CURRENT_TIMESTAMP() as now";
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "TRUE" : "FALSE";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsCaseInsensitiveLike() {
        return false;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No create schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public String[] getDropSchemaCommand(String schemaName) {
        throw new UnsupportedOperationException("No drop schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public String getCurrentSchemaCommand() {
        throw new UnsupportedOperationException("No current schema syntax supported by " + ((Object)((Object)this)).getClass().getName());
    }

    public SchemaNameResolver getSchemaNameResolver() {
        return (connection, dialect) -> "";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getAddColumnString() {
        return "ADD COLUMN";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        return super.getAddForeignKeyConstraintString(constraintName, foreignKey, referencedTable, primaryKey, false);
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("Cannot add primary key constraint in Cloud Spanner.");
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return LOCKING_STRATEGY;
    }

    public String getForUpdateString(LockOptions lockOptions) {
        return "";
    }

    public String getForUpdateString() {
        return "";
    }

    public String getForUpdateString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getWriteLockString(int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getWriteLockString(String aliases, int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getReadLockString(int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getReadLockString(String aliases, int timeout) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public String getForUpdateNowaitString() {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getForUpdateNowaitString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getForUpdateSkipLockedString() {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public String getForUpdateSkipLockedString(String aliases) {
        throw new UnsupportedOperationException("Cloud Spanner does not support selecting for lock acquisition.");
    }

    public Exporter<Sequence> getSequenceExporter() {
        return NOOP_EXPORTER;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public char openQuote() {
        return '`';
    }

    public char closeQuote() {
        return '`';
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsVariableLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return sql + (hasOffset ? " limit ? offset ?" : " limit ?");
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public String getCastTypeName(int code) {
        switch (code) {
            case 12: {
                return "STRING";
            }
        }
        return super.getCastTypeName(code);
    }

    static class EmptyExporter<T extends Exportable>
    implements Exporter<T> {
        EmptyExporter() {
        }

        public String[] getSqlCreateStrings(T exportable, Metadata metadata) {
            return new String[0];
        }

        public String[] getSqlDropStrings(T exportable, Metadata metadata) {
            return new String[0];
        }
    }

    static class DoNothingLockingStrategy
    implements LockingStrategy {
        DoNothingLockingStrategy() {
        }

        public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, LockingStrategyException {
        }
    }
}

