/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate;

import com.google.cloud.spanner.hibernate.SpannerDialect;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaManagementTool;
import java.util.Map;
import java.util.Objects;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.hql.spi.id.inline.InlineIdsOrClauseBulkIdStrategy;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceContributor;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tool.schema.spi.SchemaManagementTool;

public class SpannerServiceContributor
implements ServiceContributor {
    private static final SpannerSchemaManagementTool SCHEMA_MANAGEMENT_TOOL = new SpannerSchemaManagementTool();
    static final String HIBERNATE_API_CLIENT_LIB_TOKEN = "sp-hib";

    public void contribute(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        if (Objects.equals(serviceRegistryBuilder.getSettings().get("hibernate.dialect"), SpannerDialect.class.getName())) {
            serviceRegistryBuilder.addInitiator(new StandardServiceInitiator(){

                public Service initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
                    return SCHEMA_MANAGEMENT_TOOL;
                }

                public Class getServiceInitiated() {
                    return SchemaManagementTool.class;
                }
            }).applySetting("hibernate.connection.userAgent", (Object)HIBERNATE_API_CLIENT_LIB_TOKEN).applySetting("hibernate.schema_update.unique_constraint_strategy", (Object)UniqueConstraintSchemaUpdateStrategy.RECREATE_QUIETLY).applySetting("hibernate.hql.bulk_id_strategy", (Object)InlineIdsOrClauseBulkIdStrategy.INSTANCE);
        }
    }
}

