/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate;

import com.google.cloud.spanner.hibernate.SpannerDialect;
import com.google.cloud.spanner.hibernate.schema.SpannerDatabaseInfo;
import com.google.cloud.spanner.hibernate.schema.SpannerTableStatements;
import com.google.cloud.spanner.hibernate.schema.TableDependencyTracker;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.Exporter;

public class SpannerTableExporter
implements Exporter<Table> {
    private final SpannerTableStatements spannerTableStatements;
    private final TableDependencyTracker tableDependencyTracker;

    public SpannerTableExporter(SpannerDialect spannerDialect) {
        this.spannerTableStatements = new SpannerTableStatements(spannerDialect);
        this.tableDependencyTracker = new TableDependencyTracker();
    }

    public String[] getSqlCreateStrings(Table currentTable, Metadata metadata) {
        SpannerTableExporter.initializeUniqueConstraints(currentTable);
        return this.buildSqlStrings(currentTable, metadata, Action.CREATE);
    }

    public String[] getSqlDropStrings(Table currentTable, Metadata metadata) {
        SpannerTableExporter.initializeUniqueConstraints(currentTable);
        return this.buildSqlStrings(currentTable, metadata, Action.DROP);
    }

    public void init(Metadata metadata, SpannerDatabaseInfo spannerDatabaseInfo, Action schemaAction) {
        this.tableDependencyTracker.initializeDependencies(metadata, schemaAction);
        this.spannerTableStatements.initializeSpannerDatabaseInfo(spannerDatabaseInfo);
    }

    private String[] buildSqlStrings(Table currentTable, Metadata metadata, Action schemaAction) {
        Collection<Table> tablesToProcess = this.tableDependencyTracker.getDependentTables(currentTable);
        List<String> ddlStatements = tablesToProcess.stream().flatMap(table -> {
            if (schemaAction == Action.CREATE) {
                return this.spannerTableStatements.createTable((Table)table, metadata).stream();
            }
            return this.spannerTableStatements.dropTable((Table)table).stream();
        }).collect(Collectors.toList());
        return ddlStatements.toArray(new String[ddlStatements.size()]);
    }

    private static void initializeUniqueConstraints(Table table) {
        Iterator colIterator = table.getColumnIterator();
        while (colIterator.hasNext()) {
            Column col = (Column)colIterator.next();
            if (!col.isUnique()) continue;
            String name = Constraint.generateName((String)"UK_", (Table)table, (Column[])new Column[]{col});
            UniqueKey uk = table.getOrCreateUniqueKey(name);
            uk.addColumn(col);
        }
    }
}

