/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.reflection;

import java.lang.reflect.Field;
import java.util.Iterator;

public class SpannerKeyFieldIterator
implements Iterator<Field> {
    private int index;
    private Class<?> clazz;
    private Field[] fields;

    public SpannerKeyFieldIterator(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean hasNext() throws SecurityException {
        while (this.hasNextPvt()) {
            if (!this.fields[this.index].isSynthetic()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    private boolean hasNextPvt() {
        if (this.fields == null) {
            this.fields = this.clazz.getDeclaredFields();
            this.index = 0;
        }
        if (this.index >= this.fields.length) {
            this.clazz = this.clazz.getSuperclass();
            if (null != this.clazz) {
                this.fields = this.clazz.getDeclaredFields();
                this.index = 0;
            }
        }
        return null != this.clazz && this.index < this.fields.length;
    }

    @Override
    public Field next() {
        Field field = this.fields[this.index];
        ++this.index;
        return field;
    }

    public static Iterable<Field> iterable(Class<?> clazz) {
        return () -> new SpannerKeyFieldIterator(clazz);
    }
}

