/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.SpannerDialect;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.Action;

public class RunBatchDdl
implements AuxiliaryDatabaseObject {
    private static final long serialVersionUID = 1L;
    private final Action schemaAction;
    private final List<String> statements;

    public RunBatchDdl(Action schemaAction) {
        this.schemaAction = schemaAction;
        this.statements = new ArrayList<String>();
        this.statements.add("RUN BATCH");
    }

    public void addAfterDdlStatement(String statement) {
        this.statements.add(statement);
    }

    public String getExportIdentifier() {
        return "RUN_BATCH_DDL";
    }

    public boolean appliesToDialect(Dialect dialect) {
        return SpannerDialect.class.isAssignableFrom(dialect.getClass());
    }

    public boolean beforeTablesOnCreation() {
        return this.schemaAction == Action.UPDATE;
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        return this.statements.toArray(new String[this.statements.size()]);
    }

    public String[] sqlDropStrings(Dialect dialect) {
        if (this.schemaAction == Action.UPDATE) {
            return new String[0];
        }
        return this.statements.toArray(new String[this.statements.size()]);
    }
}

