/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.Interleaved;
import com.google.cloud.spanner.hibernate.reflection.SpannerEntityFieldKey;
import com.google.cloud.spanner.hibernate.reflection.SpannerKeyFieldIterator;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;

class SchemaUtils {
    private SchemaUtils() {
    }

    public static Interleaved getInterleaveAnnotation(Table table, Metadata metadata) {
        Class<?> entityClass = SchemaUtils.getEntityClass(table, metadata);
        return null != entityClass ? entityClass.getAnnotation(Interleaved.class) : null;
    }

    public static Class<?> getEntityClass(Table table, Metadata metadata) {
        for (PersistentClass pc : metadata.getEntityBindings()) {
            if (!pc.getTable().equals(table) || pc.getMappedClass() == null) continue;
            return pc.getMappedClass();
        }
        return null;
    }

    public static Table getTable(Class<?> entityClass, Metadata metadata) {
        PersistentClass pc = metadata.getEntityBinding(entityClass.getCanonicalName());
        if (pc != null) {
            return pc.getTable();
        }
        throw new IllegalArgumentException(String.format("Could not find table for entity class %s.", entityClass.getName()));
    }

    public static boolean validateInterleaved(Class<?> potentialChild) {
        Interleaved interleaved = potentialChild.getAnnotation(Interleaved.class);
        if (null == interleaved) {
            return true;
        }
        try {
            Set<SpannerEntityFieldKey> childIds = SchemaUtils.resolveIdFields(potentialChild, new HashSet());
            Set<SpannerEntityFieldKey> parentIds = SchemaUtils.resolveIdFields(interleaved.parentEntity(), new HashSet());
            return childIds.size() > parentIds.size() && childIds.containsAll(parentIds);
        }
        catch (SecurityException se) {
            return true;
        }
    }

    public static Set<SpannerEntityFieldKey> resolveIdFields(Class<?> entity, Set<Class<?>> resolved) throws SecurityException {
        Field embeddedId = SchemaUtils.getEmbeddedId(entity);
        Class<?> compositeKeyClazz = embeddedId != null ? embeddedId.getType() : entity;
        boolean keepAllFields = embeddedId != null || entity.getAnnotation(Embeddable.class) != null;
        HashSet<SpannerEntityFieldKey> ids = new HashSet<SpannerEntityFieldKey>();
        for (Field field : SpannerKeyFieldIterator.iterable(compositeKeyClazz)) {
            if (!keepAllFields && field.getAnnotation(Id.class) == null) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.getAnnotation(Embeddable.class) != null && !resolved.contains(fieldType)) {
                resolved.add(entity);
                ids.addAll(SchemaUtils.resolveIdFields(fieldType, resolved));
                continue;
            }
            ids.add(new SpannerEntityFieldKey(fieldType, field.getName()));
        }
        return ids;
    }

    public static Field getEmbeddedId(Class<?> entity) throws SecurityException {
        for (Field field : SpannerKeyFieldIterator.iterable(entity)) {
            if (field.getAnnotation(EmbeddedId.class) == null) continue;
            return field;
        }
        return null;
    }
}

