/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class SpannerDatabaseInfo {
    private final Set<String> tableNames;
    private final Set<String> indexNames;
    private final DatabaseMetaData databaseMetaData;

    public SpannerDatabaseInfo(DatabaseMetaData databaseMetaData) throws SQLException {
        this.tableNames = SpannerDatabaseInfo.extractDatabaseTables(databaseMetaData);
        this.indexNames = SpannerDatabaseInfo.extractDatabaseIndices(databaseMetaData);
        this.databaseMetaData = databaseMetaData;
    }

    public Set<String> getAllTables() {
        return this.tableNames;
    }

    public Set<String> getAllIndices() {
        return this.indexNames;
    }

    public Set<String> getImportedForeignKeys(String tableName) {
        try {
            HashSet<String> foreignKeys = new HashSet<String>();
            ResultSet rs = this.databaseMetaData.getImportedKeys(null, null, tableName);
            while (rs.next()) {
                foreignKeys.add(rs.getString("FK_NAME"));
            }
            rs.close();
            return foreignKeys;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to lookup Spanner Database foreign keys for table: " + tableName, e);
        }
    }

    private static Set<String> extractDatabaseTables(DatabaseMetaData databaseMetaData) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
        while (resultSet.next()) {
            String type = resultSet.getString("TABLE_TYPE");
            if (!type.equals("TABLE")) continue;
            result.add(resultSet.getString("TABLE_NAME"));
        }
        resultSet.close();
        return result;
    }

    private static Set<String> extractDatabaseIndices(DatabaseMetaData databaseMetaData) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        ResultSet indexResultSet = databaseMetaData.getIndexInfo(null, null, null, false, false);
        while (indexResultSet.next()) {
            String name = indexResultSet.getString("INDEX_NAME");
            result.add(name);
        }
        indexResultSet.close();
        return result;
    }
}

