/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.schema.SpannerDatabaseInfo;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;

public class SpannerForeignKeyExporter
extends StandardForeignKeyExporter {
    private SpannerDatabaseInfo spannerDatabaseInfo;

    public SpannerForeignKeyExporter(Dialect dialect) {
        super(dialect);
    }

    public void init(SpannerDatabaseInfo spannerDatabaseInfo) {
        this.spannerDatabaseInfo = spannerDatabaseInfo;
    }

    public String[] getSqlDropStrings(ForeignKey foreignKey, Metadata metadata, SqlStringGenerationContext context) {
        if (this.spannerDatabaseInfo == null) {
            throw new IllegalStateException("Cannot determine which foreign keys to drop because spannerDatabaseInfo was null.");
        }
        if (this.foreignKeyExists(foreignKey)) {
            return super.getSqlDropStrings(foreignKey, metadata, context);
        }
        return new String[0];
    }

    private boolean foreignKeyExists(ForeignKey foreignKey) {
        String table = foreignKey.getTable().getName();
        return this.spannerDatabaseInfo.getAllTables().contains(table) && this.spannerDatabaseInfo.getImportedForeignKeys(table).contains(foreignKey.getName());
    }
}

