/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.schema.RunBatchDdl;
import com.google.cloud.spanner.hibernate.schema.SpannerDatabaseInfo;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaManagementTool;
import com.google.cloud.spanner.hibernate.schema.StartBatchDdl;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class SpannerSchemaCreator
implements SchemaCreator {
    private final SpannerSchemaManagementTool tool;
    private final SchemaCreator schemaCreator;

    public SpannerSchemaCreator(SpannerSchemaManagementTool tool, SchemaCreator schemaCreator) {
        this.tool = tool;
        this.schemaCreator = schemaCreator;
    }

    public void doCreation(Metadata metadata, ExecutionOptions options, SourceDescriptor sourceDescriptor, TargetDescriptor targetDescriptor) {
        metadata.getDatabase().addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new StartBatchDdl(Action.CREATE));
        metadata.getDatabase().addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new RunBatchDdl(Action.CREATE));
        try (Connection connection = this.tool.getDatabaseMetadataConnection(options);){
            SpannerDatabaseInfo spannerDatabaseInfo = new SpannerDatabaseInfo(connection.getMetaData());
            this.tool.getSpannerTableExporter(options).init(metadata, spannerDatabaseInfo, Action.CREATE);
            this.tool.getForeignKeyExporter(options).init(spannerDatabaseInfo);
            this.schemaCreator.doCreation(metadata, options, sourceDescriptor, targetDescriptor);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update Spanner table schema.", e);
        }
    }
}

