/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.schema.RunBatchDdl;
import com.google.cloud.spanner.hibernate.schema.SpannerDatabaseInfo;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaManagementTool;
import com.google.cloud.spanner.hibernate.schema.StartBatchDdl;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class SpannerSchemaDropper
implements SchemaDropper {
    private final SpannerSchemaManagementTool tool;
    private final SchemaDropper schemaDropper;

    public SpannerSchemaDropper(SpannerSchemaManagementTool tool, SchemaDropper schemaDropper) {
        this.tool = tool;
        this.schemaDropper = schemaDropper;
    }

    public void doDrop(Metadata metadata, ExecutionOptions options, SourceDescriptor sourceDescriptor, TargetDescriptor targetDescriptor) {
        metadata.getDatabase().addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new StartBatchDdl(Action.DROP));
        metadata.getDatabase().addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new RunBatchDdl(Action.DROP));
        try (Connection connection = this.tool.getDatabaseMetadataConnection(options);){
            SpannerDatabaseInfo spannerDatabaseInfo = new SpannerDatabaseInfo(connection.getMetaData());
            this.tool.getSpannerTableExporter(options).init(metadata, spannerDatabaseInfo, Action.DROP);
            this.tool.getForeignKeyExporter(options).init(spannerDatabaseInfo);
            this.schemaDropper.doDrop(metadata, options, sourceDescriptor, targetDescriptor);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update Spanner table schema.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DelayedDropAction buildDelayedAction(Metadata metadata, ExecutionOptions options, SourceDescriptor sourceDescriptor) {
        try (Connection connection = this.tool.getDatabaseMetadataConnection(options);){
            SpannerDatabaseInfo spannerDatabaseInfo = new SpannerDatabaseInfo(connection.getMetaData());
            this.tool.getSpannerTableExporter(options).init(metadata, spannerDatabaseInfo, Action.DROP);
            this.tool.getForeignKeyExporter(options).init(spannerDatabaseInfo);
            DelayedDropAction delayedDropAction = this.schemaDropper.buildDelayedAction(metadata, options, sourceDescriptor);
            return delayedDropAction;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update Spanner table schema.", e);
        }
    }
}

