/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.SpannerTableExporter;
import com.google.cloud.spanner.hibernate.schema.SpannerForeignKeyExporter;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaCreator;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaDropper;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaMigrator;
import java.sql.Connection;
import java.util.Map;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaMigrator;

public class SpannerSchemaManagementTool
extends HibernateSchemaManagementTool {
    public SchemaCreator getSchemaCreator(Map options) {
        return new SpannerSchemaCreator(this, super.getSchemaCreator(options));
    }

    public SchemaDropper getSchemaDropper(Map options) {
        return new SpannerSchemaDropper(this, super.getSchemaDropper(options));
    }

    public SchemaMigrator getSchemaMigrator(Map options) {
        return new SpannerSchemaMigrator(this, super.getSchemaMigrator(options));
    }

    SpannerTableExporter getSpannerTableExporter(ExecutionOptions options) {
        JdbcContext jdbcContext = this.resolveJdbcContext(options.getConfigurationValues());
        return (SpannerTableExporter)jdbcContext.getDialect().getTableExporter();
    }

    SpannerForeignKeyExporter getForeignKeyExporter(ExecutionOptions options) {
        JdbcContext jdbcContext = this.resolveJdbcContext(options.getConfigurationValues());
        return (SpannerForeignKeyExporter)jdbcContext.getDialect().getForeignKeyExporter();
    }

    Connection getDatabaseMetadataConnection(ExecutionOptions options) {
        JdbcContext jdbcContext = this.resolveJdbcContext(options.getConfigurationValues());
        DdlTransactionIsolator ddlTransactionIsolator = this.getDdlTransactionIsolator(jdbcContext);
        return ddlTransactionIsolator.getIsolatedConnection();
    }
}

