/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.schema.RunBatchDdl;
import com.google.cloud.spanner.hibernate.schema.SpannerDatabaseInfo;
import com.google.cloud.spanner.hibernate.schema.SpannerSchemaManagementTool;
import com.google.cloud.spanner.hibernate.schema.StartBatchDdl;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.tool.schema.Action;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.TargetDescriptor;

public class SpannerSchemaMigrator
implements SchemaMigrator {
    private final SpannerSchemaManagementTool tool;
    private final SchemaMigrator schemaMigrator;

    public SpannerSchemaMigrator(SpannerSchemaManagementTool tool, SchemaMigrator schemaMigrator) {
        this.tool = tool;
        this.schemaMigrator = schemaMigrator;
    }

    public void doMigration(Metadata metadata, ExecutionOptions options, TargetDescriptor targetDescriptor) {
        metadata.getDatabase().addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new StartBatchDdl(Action.UPDATE));
        metadata.getDatabase().addAuxiliaryDatabaseObject((AuxiliaryDatabaseObject)new RunBatchDdl(Action.UPDATE));
        try (Connection connection = this.tool.getDatabaseMetadataConnection(options);){
            SpannerDatabaseInfo spannerDatabaseInfo = new SpannerDatabaseInfo(connection.getMetaData());
            this.tool.getSpannerTableExporter(options).init(metadata, spannerDatabaseInfo, Action.UPDATE);
            this.tool.getForeignKeyExporter(options).init(spannerDatabaseInfo);
            this.schemaMigrator.doMigration(metadata, options, targetDescriptor);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to update Spanner table schema.", e);
        }
    }
}

