/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.hibernate.Interleaved;
import com.google.cloud.spanner.hibernate.SpannerDialect;
import com.google.cloud.spanner.hibernate.schema.RunBatchDdl;
import com.google.cloud.spanner.hibernate.schema.SchemaUtils;
import com.google.cloud.spanner.hibernate.schema.SpannerDatabaseInfo;
import com.google.cloud.spanner.hibernate.types.SpannerArrayListType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class SpannerTableStatements {
    private static final String CREATE_TABLE_TEMPLATE = "create table {0} ({1}) PRIMARY KEY ({2}){3}";
    private final SpannerDialect spannerDialect;
    private SpannerDatabaseInfo spannerDatabaseInfo;

    public SpannerTableStatements(SpannerDialect spannerDialect) {
        this.spannerDialect = spannerDialect;
    }

    public void initializeSpannerDatabaseInfo(SpannerDatabaseInfo spannerDatabaseInfo) {
        this.spannerDatabaseInfo = spannerDatabaseInfo;
    }

    public List<String> dropTable(Table table) {
        ArrayList<String> dropStrings = new ArrayList<String>();
        for (String indexName : this.getTableIndices(table)) {
            if (!this.spannerDatabaseInfo.getAllIndices().contains(indexName)) continue;
            dropStrings.add("drop index " + indexName);
        }
        if (this.spannerDatabaseInfo.getAllTables().contains(table.getName())) {
            dropStrings.add(this.spannerDialect.getDropTableString(table.getQuotedName()));
        }
        return dropStrings;
    }

    private Set<String> getTableIndices(Table table) {
        HashSet<String> tableIndices = new HashSet<String>();
        Iterator indexIterator = table.getIndexIterator();
        while (indexIterator.hasNext()) {
            tableIndices.add(((Index)indexIterator.next()).getName());
        }
        Iterator keyIterator = table.getUniqueKeyIterator();
        while (keyIterator.hasNext()) {
            tableIndices.add(((UniqueKey)keyIterator.next()).getName());
        }
        return tableIndices;
    }

    public List<String> createTable(Table table, Metadata metadata) {
        if (this.spannerDatabaseInfo.getAllTables().contains(table.getName())) {
            return Collections.EMPTY_LIST;
        }
        Iterable<Object> keyColumns = table.hasPrimaryKey() ? SpannerTableStatements.getSortedPkColumns(table, metadata) : (this.isElementCollection(table, metadata) ? () -> ((Table)table).getColumnIterator() : Collections.emptyList());
        return this.getCreateTableStrings(table, metadata, keyColumns);
    }

    private boolean isElementCollection(Table table, Metadata metadata) {
        for (Collection collection : metadata.getCollectionBindings()) {
            if (!collection.getCollectionTable().equals(table)) continue;
            return true;
        }
        return false;
    }

    private List<String> getCreateTableStrings(Table table, Metadata metadata, Iterable<Column> keyColumns) {
        String primaryKeyColNames = StreamSupport.stream(keyColumns.spliterator(), false).map(Column::getQuotedName).collect(Collectors.joining(","));
        Iterable columnIterable = () -> table.getColumnIterator();
        String allColumnNames = StreamSupport.stream(columnIterable.spliterator(), false).map(column -> this.buildColumnTypeString((Column)column, metadata)).collect(Collectors.joining(","));
        ArrayList<String> statements = new ArrayList<String>();
        String createTableString = MessageFormat.format(CREATE_TABLE_TEMPLATE, table.getQuotedName(), allColumnNames, primaryKeyColNames, SpannerTableStatements.getInterleavedClause(table, metadata));
        statements.add(createTableString);
        if (table.getName().equals("hibernate_sequence")) {
            this.addStatementAfterDdlBatch(metadata, "INSERT INTO hibernate_sequence (next_val) VALUES(1)");
        }
        return statements;
    }

    private void addStatementAfterDdlBatch(Metadata metadata, String statement) {
        Optional<RunBatchDdl> runBatchDdl = metadata.getDatabase().getAuxiliaryDatabaseObjects().stream().filter(obj -> obj instanceof RunBatchDdl).map(obj -> (RunBatchDdl)obj).findFirst();
        if (!runBatchDdl.isPresent()) {
            throw new IllegalStateException("Failed to generate INSERT statement for the hibernate_sequence table. The Spanner dialect did not create auxiliary database objects correctly. Please post a question to https://github.com/GoogleCloudPlatform/google-cloud-spanner-hibernate/issues");
        }
        runBatchDdl.get().addAfterDdlStatement(statement);
    }

    private String buildColumnTypeString(Column col, Metadata metadata) {
        String typeString;
        if (col.getValue() != null && col.getSqlTypeCode((Mapping)metadata) == 2003) {
            Type.Code typeCode = ((SpannerArrayListType)col.getValue().getType()).getSpannerSqlType();
            String arrayType = typeCode.toString();
            if (typeCode == Type.Code.STRING || typeCode == Type.Code.BYTES) {
                arrayType = arrayType + "(" + col.getLength() + ")";
            }
            typeString = String.format("ARRAY<%s>", arrayType);
        } else {
            typeString = col.getSqlType((Dialect)this.spannerDialect, (Mapping)metadata);
        }
        return col.getQuotedName() + " " + typeString + (col.isNullable() ? this.spannerDialect.getNullColumnString() : " not null");
    }

    private static String getInterleavedClause(Table table, Metadata metadata) {
        Interleaved interleaved = SchemaUtils.getInterleaveAnnotation(table, metadata);
        if (interleaved != null) {
            Table parentTable = SchemaUtils.getTable(interleaved.parentEntity(), metadata);
            String interleaveClause = ", INTERLEAVE IN PARENT " + parentTable.getQuotedName();
            if (interleaved.cascadeDelete()) {
                interleaveClause = interleaveClause + " ON DELETE CASCADE";
            }
            return interleaveClause;
        }
        return "";
    }

    private static List<Column> getSortedPkColumns(Table table, Metadata metadata) {
        Interleaved interleaved = SchemaUtils.getInterleaveAnnotation(table, metadata);
        if (interleaved == null) {
            return table.getPrimaryKey().getColumns();
        }
        Table parentTable = SchemaUtils.getTable(interleaved.parentEntity(), metadata);
        List<Column> sortedParentPkColumns = SpannerTableStatements.getSortedPkColumns(parentTable, metadata);
        List sortedCurrentPkColumns = table.getPrimaryKey().getColumns().stream().filter(column -> !sortedParentPkColumns.contains(column)).collect(Collectors.toList());
        ArrayList<Column> currentPkColumns = new ArrayList<Column>();
        currentPkColumns.addAll(sortedParentPkColumns);
        currentPkColumns.addAll(sortedCurrentPkColumns);
        return currentPkColumns;
    }
}

