/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.schema;

import com.google.cloud.spanner.hibernate.Interleaved;
import com.google.cloud.spanner.hibernate.schema.SchemaUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.internal.HEMLogging;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.Action;
import org.jboss.logging.Logger;

public class TableDependencyTracker {
    private static final Logger log = HEMLogging.logger(TableDependencyTracker.class);
    private Map<Table, Table> tableDependencies;
    private HashSet<Table> processedTables;

    public void initializeDependencies(Metadata metadata, Action schemaAction) {
        HashMap<Table, Table> dependencies = new HashMap<Table, Table>();
        for (Table childTable : metadata.collectTableMappings()) {
            Class<?> entity = SchemaUtils.getEntityClass(childTable, metadata);
            Interleaved interleaved = entity != null ? entity.getAnnotation(Interleaved.class) : null;
            if (interleaved == null) continue;
            if (!SchemaUtils.validateInterleaved(entity)) {
                log.warnf("Composite key for Interleaved table '%s' should be a superset of the parent's key.", (Object)entity.getName());
            }
            if (schemaAction == Action.CREATE || schemaAction == Action.UPDATE) {
                dependencies.put(childTable, SchemaUtils.getTable(interleaved.parentEntity(), metadata));
                continue;
            }
            dependencies.put(SchemaUtils.getTable(interleaved.parentEntity(), metadata), childTable);
        }
        this.tableDependencies = dependencies;
        this.processedTables = new HashSet();
    }

    public Collection<Table> getDependentTables(Table table) {
        ArrayDeque<Table> tableStack = new ArrayDeque<Table>();
        while (table != null && !this.processedTables.contains(table)) {
            tableStack.push(table);
            this.processedTables.add(table);
            table = this.tableDependencies.get(table);
        }
        return tableStack;
    }
}

