/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.types.internal;

import com.google.cloud.spanner.Type;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.usertype.DynamicParameterizedType;

public class ArrayJavaTypeDescriptor
extends AbstractTypeDescriptor<List<?>>
implements DynamicParameterizedType {
    public static final ArrayJavaTypeDescriptor INSTANCE = new ArrayJavaTypeDescriptor();
    private Class<?> spannerType = Object.class;
    private Type.Code spannerTypeCode = Type.Code.STRUCT;

    public ArrayJavaTypeDescriptor() {
        super(List.class);
    }

    public List<?> fromString(String string) {
        throw new UnsupportedOperationException("Creating a Java list from String is not supported.");
    }

    public <X> X unwrap(List<?> value, Class<X> type, WrapperOptions options) {
        if (this.spannerType == Integer.class) {
            value = value.stream().map(Integer::longValue).collect(Collectors.toList());
        }
        return (X)value.toArray();
    }

    public List<?> wrap(Object value, WrapperOptions options) {
        try {
            if (value instanceof Array) {
                Array sqlArray = (Array)value;
                return Arrays.asList((Object[])sqlArray.getArray());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to convert SQL array type to a Java list: ", e);
        }
        throw new UnsupportedOperationException("Unsupported type to convert: " + value.getClass() + " Java type descriptor only supports converting SQL array types.");
    }

    public void setParameterValues(Properties parameters) {
        Class listParamType;
        if (!parameters.get("org.hibernate.type.ParameterType.returnedClass").equals(List.class.getName())) {
            String message = String.format("Found invalid type annotation on field: %s. The SpannerArrayListType must be applied on a java.util.List entity field.", parameters.get("org.hibernate.type.ParameterType.propertyName"));
            throw new IllegalArgumentException(message);
        }
        Class<?> entityClass = ArrayJavaTypeDescriptor.getClass(parameters.getProperty("org.hibernate.type.ParameterType.entityClass"));
        Field field = FieldUtils.getDeclaredField(entityClass, (String)parameters.getProperty("org.hibernate.type.ParameterType.propertyName"), (boolean)true);
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("You must specify an explicit parameterized type for your List type; i.e. List<Integer>");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        this.spannerType = listParamType = (Class)parameterizedType.getActualTypeArguments()[0];
        this.spannerTypeCode = ArrayJavaTypeDescriptor.getSpannerTypeCode(listParamType);
    }

    private static Class<?> getClass(String name) {
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find class: " + name, e);
        }
    }

    public Type.Code getSpannerTypeCode() {
        return this.spannerTypeCode;
    }

    private static Type.Code getSpannerTypeCode(Class<?> javaType) {
        if (Integer.class.isAssignableFrom(javaType)) {
            return Type.Code.INT64;
        }
        if (Long.class.isAssignableFrom(javaType)) {
            return Type.Code.INT64;
        }
        if (Double.class.isAssignableFrom(javaType)) {
            return Type.Code.FLOAT64;
        }
        if (String.class.isAssignableFrom(javaType)) {
            return Type.Code.STRING;
        }
        if (UUID.class.isAssignableFrom(javaType)) {
            return Type.Code.STRING;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return Type.Code.TIMESTAMP;
        }
        if (Boolean.class.isAssignableFrom(javaType)) {
            return Type.Code.BOOL;
        }
        if (BigDecimal.class.isAssignableFrom(javaType)) {
            return Type.Code.NUMERIC;
        }
        if (byte[].class.isAssignableFrom(javaType)) {
            return Type.Code.BYTES;
        }
        throw new UnsupportedOperationException("The " + javaType + " is not supported as a Spanner array type.");
    }
}

