/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.types.internal;

import com.google.cloud.spanner.hibernate.types.internal.ArrayJavaTypeDescriptor;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class ArraySqlTypeDescriptor
implements SqlTypeDescriptor {
    public static final ArraySqlTypeDescriptor INSTANCE = new ArraySqlTypeDescriptor();

    public int getSqlType() {
        return 2003;
    }

    public boolean canBeRemapped() {
        return true;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                ArrayJavaTypeDescriptor arrayJavaTypeDescriptor = (ArrayJavaTypeDescriptor)javaTypeDescriptor;
                st.setArray(index, st.getConnection().createArrayOf(arrayJavaTypeDescriptor.getSpannerTypeCode().toString(), arrayJavaTypeDescriptor.unwrap((List)value, Object[].class, options)));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) {
                throw new UnsupportedOperationException("Binding by name is not supported!");
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)rs.getArray(name), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getArray(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getArray(name), options);
            }
        };
    }
}

