/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.types.internal;

import com.google.gson.Gson;
import java.util.Properties;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.usertype.DynamicParameterizedType;

public class JsonJavaTypeDescriptor
extends AbstractTypeDescriptor<Object>
implements DynamicParameterizedType {
    private static final Gson gson = new Gson();
    private Class<?> propertyType = Object.class;

    public JsonJavaTypeDescriptor() {
        super(Object.class);
    }

    public Object fromString(String input) {
        if (String.class.isAssignableFrom(this.propertyType)) {
            return input;
        }
        return gson.fromJson(input, this.propertyType);
    }

    public <X> X unwrap(Object value, Class<X> type, WrapperOptions options) {
        return (X)gson.toJson(value);
    }

    public <X> Object wrap(X value, WrapperOptions options) {
        if (value instanceof String) {
            return this.fromString((String)value);
        }
        throw new UnsupportedOperationException("Unable to convert type " + value.getClass() + " to JSON.");
    }

    public void setParameterValues(Properties parameters) {
        try {
            this.propertyType = Class.forName(parameters.getProperty("org.hibernate.type.ParameterType.returnedClass"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to map JSON entity column.", e);
        }
    }
}

