/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.hibernate.types.internal;

import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.hibernate.types.internal.JsonJavaTypeDescriptor;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class JsonSqlTypeDescriptor
implements SqlTypeDescriptor {
    public int getSqlType() {
        return 100011;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                JsonJavaTypeDescriptor typeDescriptor = (JsonJavaTypeDescriptor)javaTypeDescriptor;
                st.setObject(index, Value.json((String)typeDescriptor.unwrap(value, String.class, options)));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) {
                throw new UnsupportedOperationException("Binding by name is not supported!");
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)rs.getString(name), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getString(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getString(name), options);
            }
        };
    }
}

