/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.Preconditions;

public final class Options {
    private Long limit;
    private Integer prefetchChunks;
    private Integer pageSize;
    private String pageToken;
    private String filter;

    public static ReadOption limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"Limit should be greater than 0");
        return new LimitOption(limit);
    }

    public static ReadAndQueryOption prefetchChunks(int prefetchChunks) {
        Preconditions.checkArgument((prefetchChunks > 0 ? 1 : 0) != 0, (Object)"prefetchChunks should be greater than 0");
        return new FlowControlOption(prefetchChunks);
    }

    public static ListOption pageSize(int pageSize) {
        return new PageSizeOption(pageSize);
    }

    public static ListOption pageToken(String pageToken) {
        return new PageTokenOption(pageToken);
    }

    public static ListOption filter(String filter) {
        return new FilterOption(filter);
    }

    private Options() {
    }

    boolean hasLimit() {
        return this.limit != null;
    }

    long limit() {
        return this.limit;
    }

    boolean hasPrefetchChunks() {
        return this.prefetchChunks != null;
    }

    int prefetchChunks() {
        return this.prefetchChunks;
    }

    boolean hasPageSize() {
        return this.pageSize != null;
    }

    int pageSize() {
        return this.pageSize;
    }

    boolean hasPageToken() {
        return this.pageToken != null;
    }

    String pageToken() {
        return this.pageToken;
    }

    boolean hasFilter() {
        return this.filter != null;
    }

    String filter() {
        return this.filter;
    }

    static Options fromReadOptions(ReadOption ... options) {
        Options readOptions = new Options();
        for (ReadOption option : options) {
            ((InternalOption)((Object)option)).appendToOptions(readOptions);
        }
        return readOptions;
    }

    static Options fromQueryOptions(QueryOption ... options) {
        Options readOptions = new Options();
        for (QueryOption option : options) {
            ((InternalOption)((Object)option)).appendToOptions(readOptions);
        }
        return readOptions;
    }

    static Options fromListOptions(ListOption ... options) {
        Options listOptions = new Options();
        for (ListOption option : options) {
            ((InternalOption)((Object)option)).appendToOptions(listOptions);
        }
        return listOptions;
    }

    static class FilterOption
    extends InternalOption
    implements ListOption {
        private final String filter;

        FilterOption(String filter) {
            this.filter = filter;
        }

        @Override
        void appendToOptions(Options options) {
            options.filter = this.filter;
        }
    }

    static class PageTokenOption
    extends InternalOption
    implements ListOption {
        private final String pageToken;

        PageTokenOption(String pageToken) {
            this.pageToken = pageToken;
        }

        String pageToken() {
            return this.pageToken;
        }

        @Override
        void appendToOptions(Options options) {
            options.pageToken = this.pageToken;
        }
    }

    static class PageSizeOption
    extends InternalOption
    implements ListOption {
        private final int pageSize;

        PageSizeOption(int pageSize) {
            this.pageSize = pageSize;
        }

        int pageSize() {
            return this.pageSize;
        }

        @Override
        void appendToOptions(Options options) {
            options.pageSize = this.pageSize;
        }
    }

    static class LimitOption
    extends InternalOption
    implements ReadOption {
        private final long limit;

        LimitOption(long limit) {
            this.limit = limit;
        }

        long limit() {
            return this.limit;
        }

        @Override
        void appendToOptions(Options options) {
            options.limit = this.limit;
        }
    }

    private static abstract class InternalOption {
        private InternalOption() {
        }

        abstract void appendToOptions(Options var1);
    }

    static final class FlowControlOption
    extends InternalOption
    implements ReadAndQueryOption {
        final int prefetchChunks;

        FlowControlOption(int prefetchChunks) {
            this.prefetchChunks = prefetchChunks;
        }

        int prefetchChunks() {
            return this.prefetchChunks;
        }

        @Override
        void appendToOptions(Options options) {
            options.prefetchChunks = this.prefetchChunks;
        }
    }

    public static interface ListOption {
    }

    public static interface QueryOption {
    }

    public static interface ReadOption {
    }

    public static interface ReadAndQueryOption
    extends ReadOption,
    QueryOption {
    }
}

