/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class AbstractReadContext
implements ReadContext,
AbstractResultSet.Listener,
SessionImpl.SessionTransaction {
    final Object lock = new Object();
    final SessionImpl session;
    final SpannerRpc rpc;
    final Span span;
    private final int defaultPrefetchChunks;
    @GuardedBy(value="lock")
    private boolean isValid = true;
    @GuardedBy(value="lock")
    private boolean isClosed = false;
    private AtomicLong seqNo = new AtomicLong();
    private static final int MAX_BUFFERED_CHUNKS = 512;

    private static void assertTimestampAvailable(boolean available) {
        Preconditions.checkState((boolean)available, (Object)"Method can only be called after read has returned data or finished");
    }

    AbstractReadContext(SessionImpl session, SpannerRpc rpc, int defaultPrefetchChunks) {
        this(session, rpc, defaultPrefetchChunks, Tracing.getTracer().getCurrentSpan());
    }

    private AbstractReadContext(SessionImpl session, SpannerRpc rpc, int defaultPrefetchChunks, Span span) {
        this.session = session;
        this.rpc = rpc;
        this.defaultPrefetchChunks = defaultPrefetchChunks;
        this.span = span;
    }

    long getSeqNo() {
        return this.seqNo.incrementAndGet();
    }

    @Override
    public final ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return this.readInternal(table, null, keys, columns, options);
    }

    @Override
    public final ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        return this.readInternal(table, (String)Preconditions.checkNotNull((Object)index), keys, columns, options);
    }

    @Override
    @Nullable
    public final Struct readRow(String table, Key key, Iterable<String> columns) {
        try (ResultSet resultSet = this.read(table, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
            Struct struct = this.consumeSingleRow(resultSet);
            return struct;
        }
    }

    @Override
    @Nullable
    public final Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
        try (ResultSet resultSet = this.readUsingIndex(table, index, KeySet.singleKey(key), columns, new Options.ReadOption[0]);){
            Struct struct = this.consumeSingleRow(resultSet);
            return struct;
        }
    }

    @Override
    public final ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
        return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.NORMAL, options);
    }

    @Override
    public final ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode readContextQueryMode) {
        switch (readContextQueryMode) {
            case PROFILE: {
                return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.PROFILE, new Options.QueryOption[0]);
            }
            case PLAN: {
                return this.executeQueryInternal(statement, ExecuteSqlRequest.QueryMode.PLAN, new Options.QueryOption[0]);
            }
        }
        throw new IllegalStateException("Unknown value for QueryAnalyzeMode : " + (Object)((Object)readContextQueryMode));
    }

    private ResultSet executeQueryInternal(Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options.QueryOption ... options) {
        Options readOptions = Options.fromQueryOptions(options);
        return this.executeQueryInternalWithOptions(statement, queryMode, readOptions, null);
    }

    ExecuteSqlRequest.Builder getExecuteSqlRequestBuilder(Statement statement, ExecuteSqlRequest.QueryMode queryMode) {
        TransactionSelector selector;
        ExecuteSqlRequest.Builder builder = ExecuteSqlRequest.newBuilder().setSql(statement.getSql()).setQueryMode(queryMode).setSession(this.session.getName());
        Map<String, Value> stmtParameters = statement.getParameters();
        if (!stmtParameters.isEmpty()) {
            Struct.Builder paramsBuilder = builder.getParamsBuilder();
            for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
            }
        }
        if ((selector = this.getTransactionSelector()) != null) {
            builder.setTransaction(selector);
        }
        builder.setSeqno(this.getSeqNo());
        return builder;
    }

    ExecuteBatchDmlRequest.Builder getExecuteBatchDmlRequestBuilder(Iterable<Statement> statements) {
        ExecuteBatchDmlRequest.Builder builder = ExecuteBatchDmlRequest.newBuilder().setSession(this.session.getName());
        int idx = 0;
        for (Statement stmt : statements) {
            builder.addStatementsBuilder();
            builder.getStatementsBuilder(idx).setSql(stmt.getSql());
            Map<String, Value> stmtParameters = stmt.getParameters();
            if (!stmtParameters.isEmpty()) {
                Struct.Builder paramsBuilder = builder.getStatementsBuilder(idx).getParamsBuilder();
                for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                    paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                    builder.getStatementsBuilder(idx).putParamTypes(param.getKey(), param.getValue().getType().toProto());
                }
            }
            ++idx;
        }
        TransactionSelector selector = this.getTransactionSelector();
        if (selector != null) {
            builder.setTransaction(selector);
        }
        builder.setSeqno(this.getSeqNo());
        return builder;
    }

    ResultSet executeQueryInternalWithOptions(Statement statement, ExecuteSqlRequest.QueryMode queryMode, Options readOptions, ByteString partitionToken) {
        this.beforeReadOrQuery();
        final ExecuteSqlRequest.Builder request = this.getExecuteSqlRequestBuilder(statement, queryMode);
        if (partitionToken != null) {
            request.setPartitionToken(partitionToken);
        }
        final int prefetchChunks = readOptions.hasPrefetchChunks() ? readOptions.prefetchChunks() : this.defaultPrefetchChunks;
        AbstractResultSet.ResumableStreamIterator stream = new AbstractResultSet.ResumableStreamIterator(512, "CloudSpannerOperation.ExecuteStreamingQuery", this.span){

            @Override
            AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                AbstractResultSet.GrpcStreamIterator stream = new AbstractResultSet.GrpcStreamIterator(prefetchChunks);
                if (resumeToken != null) {
                    request.setResumeToken(resumeToken);
                }
                SpannerRpc.StreamingCall call = AbstractReadContext.this.rpc.executeQuery(request.build(), stream.consumer(), AbstractReadContext.this.session.getOptions());
                call.request(prefetchChunks);
                stream.setCall(call);
                return stream;
            }
        };
        return new AbstractResultSet.GrpcResultSet(stream, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beforeReadOrQuery() {
        Object object = this.lock;
        synchronized (object) {
            this.beforeReadOrQueryLocked();
        }
    }

    @GuardedBy(value="lock")
    void beforeReadOrQueryLocked() {
        Preconditions.checkState((boolean)this.isValid, (Object)"Context has been invalidated by a new operation on the session");
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Context has been closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invalidate() {
        Object object = this.lock;
        synchronized (object) {
            this.isValid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.span.end(TraceUtil.END_SPAN_OPTIONS);
        Object object = this.lock;
        synchronized (object) {
            this.isClosed = true;
        }
    }

    @Nullable
    abstract TransactionSelector getTransactionSelector();

    @Override
    public void onTransactionMetadata(Transaction transaction) {
    }

    @Override
    public void onError(SpannerException e) {
    }

    @Override
    public void onDone() {
    }

    private ResultSet readInternal(String table, @Nullable String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
        Options readOptions = Options.fromReadOptions(options);
        return this.readInternalWithOptions(table, index, keys, columns, readOptions, null);
    }

    ResultSet readInternalWithOptions(String table, @Nullable String index, KeySet keys, Iterable<String> columns, Options readOptions, ByteString partitionToken) {
        TransactionSelector selector;
        this.beforeReadOrQuery();
        final ReadRequest.Builder builder = ReadRequest.newBuilder().setSession(this.session.getName()).setTable((String)Preconditions.checkNotNull((Object)table)).addAllColumns(columns);
        if (readOptions.hasLimit()) {
            builder.setLimit(readOptions.limit());
        }
        keys.appendToProto(builder.getKeySetBuilder());
        if (index != null) {
            builder.setIndex(index);
        }
        if ((selector = this.getTransactionSelector()) != null) {
            builder.setTransaction(selector);
        }
        if (partitionToken != null) {
            builder.setPartitionToken(partitionToken);
        }
        final int prefetchChunks = readOptions.hasPrefetchChunks() ? readOptions.prefetchChunks() : this.defaultPrefetchChunks;
        AbstractResultSet.ResumableStreamIterator stream = new AbstractResultSet.ResumableStreamIterator(512, "CloudSpannerOperation.ExecuteStreamingRead", this.span){

            @Override
            AbstractResultSet.CloseableIterator<PartialResultSet> startStream(@Nullable ByteString resumeToken) {
                AbstractResultSet.GrpcStreamIterator stream = new AbstractResultSet.GrpcStreamIterator(prefetchChunks);
                if (resumeToken != null) {
                    builder.setResumeToken(resumeToken);
                }
                SpannerRpc.StreamingCall call = AbstractReadContext.this.rpc.read(builder.build(), stream.consumer(), AbstractReadContext.this.session.getOptions());
                call.request(prefetchChunks);
                stream.setCall(call);
                return stream;
            }
        };
        AbstractResultSet.GrpcResultSet resultSet = new AbstractResultSet.GrpcResultSet(stream, this);
        return resultSet;
    }

    private Struct consumeSingleRow(ResultSet resultSet) {
        if (!resultSet.next()) {
            return null;
        }
        Struct row = resultSet.getCurrentRowAsStruct();
        if (resultSet.next()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Multiple rows returned for single key");
        }
        return row;
    }

    static class MultiUseReadOnlyTransaction
    extends AbstractReadContext
    implements ReadOnlyTransaction {
        private TimestampBound bound;
        private final Object txnLock = new Object();
        @GuardedBy(value="txnLock")
        private Timestamp timestamp;
        @GuardedBy(value="txnLock")
        private ByteString transactionId;

        MultiUseReadOnlyTransaction(SessionImpl session, TimestampBound bound, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, rpc, defaultPrefetchChunks);
            Preconditions.checkArgument((bound.getMode() != TimestampBound.Mode.MAX_STALENESS && bound.getMode() != TimestampBound.Mode.MIN_READ_TIMESTAMP ? 1 : 0) != 0, (String)"Bounded staleness mode %s is not supported for multi-use read-only transactions. Create a single-use read or read-only transaction instead.", (Object)((Object)bound.getMode()));
            this.bound = bound;
        }

        MultiUseReadOnlyTransaction(SessionImpl session, ByteString transactionId, Timestamp timestamp, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, rpc, defaultPrefetchChunks);
            this.transactionId = transactionId;
            this.timestamp = timestamp;
        }

        @Override
        void beforeReadOrQuery() {
            super.beforeReadOrQuery();
            this.initTransaction();
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            TransactionSelector selector = TransactionSelector.newBuilder().setId(this.transactionId).build();
            return selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timestamp getReadTimestamp() {
            Object object = this.txnLock;
            synchronized (object) {
                AbstractReadContext.assertTimestampAvailable(this.timestamp != null);
                return this.timestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteString getTransactionId() {
            Object object = this.txnLock;
            synchronized (object) {
                return this.transactionId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initTransaction() {
            SessionImpl.throwIfTransactionsPending();
            Object object = this.txnLock;
            synchronized (object) {
                if (this.transactionId != null) {
                    return;
                }
                this.span.addAnnotation("Creating Transaction");
                try {
                    TransactionOptions.Builder options = TransactionOptions.newBuilder();
                    this.bound.applyToBuilder(options.getReadOnlyBuilder()).setReturnReadTimestamp(true);
                    BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.session.getName()).setOptions(options).build();
                    Transaction transaction = this.rpc.beginTransaction(request, this.session.getOptions());
                    if (!transaction.hasReadTimestamp()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.read_timestamp metadata field");
                    }
                    if (transaction.getId().isEmpty()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.id metadata field");
                    }
                    try {
                        this.timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)transaction.getReadTimestamp());
                    }
                    catch (IllegalArgumentException e) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Bad value in transaction.read_timestamp metadata field", e);
                    }
                    this.transactionId = transaction.getId();
                    this.span.addAnnotation("Transaction Creation Done", TraceUtil.getTransactionAnnotations(transaction));
                }
                catch (SpannerException e) {
                    this.span.addAnnotation("Transaction Creation Failed", TraceUtil.getExceptionAnnotations(e));
                    throw e;
                }
            }
        }
    }

    static class SingleUseReadOnlyTransaction
    extends SingleReadContext
    implements ReadOnlyTransaction {
        @GuardedBy(value="lock")
        private Timestamp timestamp;

        SingleUseReadOnlyTransaction(SessionImpl session, TimestampBound bound, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, bound, rpc, defaultPrefetchChunks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Timestamp getReadTimestamp() {
            Object object = this.lock;
            synchronized (object) {
                AbstractReadContext.assertTimestampAvailable(this.timestamp != null);
                return this.timestamp;
            }
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            TransactionOptions.Builder options = TransactionOptions.newBuilder();
            this.bound.applyToBuilder(options.getReadOnlyBuilder()).setReturnReadTimestamp(true);
            return TransactionSelector.newBuilder().setSingleUse(options).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTransactionMetadata(Transaction transaction) {
            Object object = this.lock;
            synchronized (object) {
                if (!transaction.hasReadTimestamp()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing expected transaction.read_timestamp metadata field");
                }
                try {
                    this.timestamp = Timestamp.fromProto((com.google.protobuf.Timestamp)transaction.getReadTimestamp());
                }
                catch (IllegalArgumentException e) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Bad value in transaction.read_timestamp metadata field", e);
                }
            }
        }
    }

    static class SingleReadContext
    extends AbstractReadContext {
        final TimestampBound bound;
        @GuardedBy(value="lock")
        private boolean used;

        SingleReadContext(SessionImpl session, TimestampBound bound, SpannerRpc rpc, int defaultPrefetchChunks) {
            super(session, rpc, defaultPrefetchChunks);
            this.bound = bound;
        }

        @Override
        @GuardedBy(value="lock")
        void beforeReadOrQueryLocked() {
            super.beforeReadOrQueryLocked();
            Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"Cannot use a single-read ReadContext for multiple reads");
            this.used = true;
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            if (this.bound.getMode() == TimestampBound.Mode.STRONG) {
                return null;
            }
            return TransactionSelector.newBuilder().setSingleUse(TransactionOptions.newBuilder().setReadOnly(this.bound.toProto())).build();
        }
    }
}

