/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.PartitionedDMLTransaction;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionManagerImpl;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

class SessionImpl
implements Session {
    private static final Tracer tracer = Tracing.getTracer();
    static final ThreadLocal<Boolean> hasPendingTransaction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final SpannerImpl spanner;
    private final String name;
    private SessionTransaction activeTransaction;
    private ByteString readyTransactionId;
    private final Map<SpannerRpc.Option, ?> options;

    static void throwIfTransactionsPending() {
        if (hasPendingTransaction.get() == Boolean.TRUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Nested transactions are not supported");
        }
    }

    SessionImpl(SpannerImpl spanner, String name, Map<SpannerRpc.Option, ?> options) {
        this.spanner = spanner;
        this.options = options;
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    Map<SpannerRpc.Option, ?> getOptions() {
        return this.options;
    }

    @Override
    public long executePartitionedUpdate(Statement stmt) {
        this.setActive(null);
        PartitionedDMLTransaction txn = new PartitionedDMLTransaction(this, this.spanner.getRpc());
        return txn.executePartitionedUpdate(stmt, ((SpannerOptions)this.spanner.getOptions()).getPartitionedDmlTimeout());
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        TransactionRunner runner = this.readWriteTransaction();
        final Collection finalMutations = mutations instanceof Collection ? (Collection)mutations : Lists.newArrayList(mutations);
        runner.run(new TransactionRunner.TransactionCallable<Void>(){

            @Override
            public Void run(TransactionContext ctx) {
                ctx.buffer(finalMutations);
                return null;
            }
        });
        return runner.getCommitTimestamp();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        this.setActive(null);
        ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
        Mutation.toProto(mutations, mutationsProto);
        CommitRequest request = CommitRequest.newBuilder().setSession(this.name).addAllMutations(mutationsProto).setSingleUseTransaction(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance())).build();
        Span span = tracer.spanBuilder("CloudSpannerOperation.Commit").startSpan();
        try (Scope s = tracer.withSpan(span);){
            CommitResponse response = this.spanner.getRpc().commit(request, this.options);
            Timestamp t = Timestamp.fromProto((com.google.protobuf.Timestamp)response.getCommitTimestamp());
            span.end(TraceUtil.END_SPAN_OPTIONS);
            Timestamp timestamp = t;
            return timestamp;
        }
        catch (IllegalArgumentException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Could not parse commit timestamp", e);
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    @Override
    public ReadContext singleUse() {
        return this.singleUse(TimestampBound.strong());
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return this.setActive(new AbstractReadContext.SingleReadContext(this, bound, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks()));
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.singleUseReadOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.setActive(new AbstractReadContext.SingleUseReadOnlyTransaction(this, bound, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks()));
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return this.readOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.setActive(new AbstractReadContext.MultiUseReadOnlyTransaction(this, bound, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks()));
    }

    @Override
    public TransactionRunner readWriteTransaction() {
        return this.setActive(new TransactionRunnerImpl(this, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks()));
    }

    @Override
    public void prepareReadWriteTransaction() {
        this.setActive(null);
        this.readyTransactionId = this.beginTransaction();
    }

    @Override
    public ApiFuture<Empty> asyncClose() {
        return this.spanner.getRpc().asyncDeleteSession(this.name, this.options);
    }

    @Override
    public void close() {
        Span span = tracer.spanBuilder("CloudSpannerOperation.DeleteSession").startSpan();
        try (Scope s = tracer.withSpan(span);){
            this.spanner.getRpc().deleteSession(this.name, this.options);
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ByteString beginTransaction() {
        Span span = tracer.spanBuilder("CloudSpannerOperation.BeginTransaction").startSpan();
        try (Scope s = tracer.withSpan(span);){
            BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.name).setOptions(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance())).build();
            Transaction txn = this.spanner.getRpc().beginTransaction(request, this.options);
            if (txn.getId().isEmpty()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing id in transaction\n" + this.getName());
            }
            span.end(TraceUtil.END_SPAN_OPTIONS);
            ByteString byteString = txn.getId();
            return byteString;
        }
        catch (RuntimeException e) {
            TraceUtil.endSpanWithFailure(span, e);
            throw e;
        }
    }

    TransactionRunnerImpl.TransactionContextImpl newTransaction() {
        TransactionRunnerImpl.TransactionContextImpl txn = new TransactionRunnerImpl.TransactionContextImpl(this, this.readyTransactionId, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks());
        return txn;
    }

    <T extends SessionTransaction> T setActive(@Nullable T ctx) {
        SessionImpl.throwIfTransactionsPending();
        if (this.activeTransaction != null) {
            this.activeTransaction.invalidate();
        }
        this.activeTransaction = ctx;
        this.readyTransactionId = null;
        return ctx;
    }

    @Override
    public TransactionManager transactionManager() {
        return new TransactionManagerImpl(this);
    }

    static interface SessionTransaction {
        public void invalidate();
    }
}

