/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.StructReader;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.Executor;

public interface AsyncResultSet
extends ResultSet {
    public CursorState tryNext() throws SpannerException;

    public ApiFuture<Void> setCallback(Executor var1, ReadyCallback var2);

    public void cancel();

    public void resume();

    public <T> ApiFuture<ImmutableList<T>> toListAsync(Function<StructReader, T> var1, Executor var2);

    public <T> ImmutableList<T> toList(Function<StructReader, T> var1) throws SpannerException;

    public static interface ReadyCallback {
        public CallbackResponse cursorReady(AsyncResultSet var1);
    }

    public static enum CallbackResponse {
        CONTINUE,
        PAUSE,
        DONE;

    }

    public static enum CursorState {
        OK,
        DONE,
        NOT_READY;

    }
}

