/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import java.util.Map;

public enum ErrorCode {
    CANCELLED(Status.CANCELLED),
    UNKNOWN(Status.UNKNOWN),
    INVALID_ARGUMENT(Status.INVALID_ARGUMENT),
    DEADLINE_EXCEEDED(Status.DEADLINE_EXCEEDED),
    NOT_FOUND(Status.NOT_FOUND),
    ALREADY_EXISTS(Status.ALREADY_EXISTS),
    PERMISSION_DENIED(Status.PERMISSION_DENIED),
    UNAUTHENTICATED(Status.UNAUTHENTICATED),
    RESOURCE_EXHAUSTED(Status.RESOURCE_EXHAUSTED),
    FAILED_PRECONDITION(Status.FAILED_PRECONDITION),
    ABORTED(Status.ABORTED),
    OUT_OF_RANGE(Status.OUT_OF_RANGE),
    UNIMPLEMENTED(Status.UNIMPLEMENTED),
    INTERNAL(Status.INTERNAL),
    UNAVAILABLE(Status.UNAVAILABLE),
    DATA_LOSS(Status.DATA_LOSS);

    private static final Map<Integer, ErrorCode> errorByRpcCode;
    private final Status.Code code;

    private ErrorCode(Status status) {
        this.code = status.getCode();
    }

    int getCode() {
        return this.code.value();
    }

    Status getGrpcStatus() {
        return this.code.toStatus();
    }

    public Status.Code getGrpcStatusCode() {
        return this.code;
    }

    static ErrorCode valueOf(String name, ErrorCode defaultValue) {
        try {
            return ErrorCode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    static ErrorCode fromGrpcStatus(Status status) {
        ErrorCode code = errorByRpcCode.get(status.getCode().value());
        return code == null ? UNKNOWN : code;
    }

    static ErrorCode fromRpcStatus(com.google.rpc.Status status) {
        ErrorCode code = errorByRpcCode.get(status.getCode());
        return code == null ? UNKNOWN : code;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ErrorCode errorCode : ErrorCode.values()) {
            builder.put((Object)errorCode.getCode(), (Object)errorCode);
        }
        errorByRpcCode = builder.build();
    }
}

