/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.TransactionSelector;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class TransactionRunnerImpl
implements SessionImpl.SessionTransaction,
TransactionRunner {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Logger txnLogger = Logger.getLogger(TransactionRunner.class.getName());
    private boolean blockNestedTxn = true;
    private final SessionImpl session;
    private Span span;
    private TransactionContextImpl txn;
    private volatile boolean isValid = true;

    @Override
    public TransactionRunner allowNestedTransaction() {
        this.blockNestedTxn = false;
        return this;
    }

    TransactionRunnerImpl(SessionImpl session, SpannerRpc rpc, int defaultPrefetchChunks) {
        this.session = session;
        this.txn = session.newTransaction();
    }

    @Override
    public void setSpan(Span span) {
        this.span = span;
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T runInternal(final TransactionRunner.TransactionCallable<T> txCallable) {
        final AtomicInteger attempt = new AtomicInteger();
        Callable retryCallable = new Callable<T>(){

            @Override
            public T call() {
                Object result;
                if (attempt.get() > 0) {
                    TransactionRunnerImpl.this.txn = TransactionRunnerImpl.this.session.newTransaction();
                }
                Preconditions.checkState((boolean)TransactionRunnerImpl.this.isValid, (Object)"TransactionRunner has been invalidated by a new operation on the session");
                attempt.incrementAndGet();
                TransactionRunnerImpl.this.span.addAnnotation("Starting Transaction Attempt", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                TransactionRunnerImpl.this.txn.ensureTxn();
                boolean shouldRollback = true;
                try {
                    result = txCallable.run(TransactionRunnerImpl.this.txn);
                    shouldRollback = false;
                }
                catch (Exception e) {
                    txnLogger.log(Level.FINE, "User-provided TransactionCallable raised exception", e);
                    if (TransactionRunnerImpl.this.txn.isAborted() || e instanceof AbortedException) {
                        TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Aborted in user operation. Retrying", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                        shouldRollback = false;
                        if (e instanceof AbortedException) {
                            throw (AbortedException)((Object)e);
                        }
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, e.getMessage(), e);
                    }
                    SpannerException toThrow = e instanceof SpannerException ? (SpannerException)((Object)e) : SpannerExceptionFactory.newSpannerException(ErrorCode.UNKNOWN, e.getMessage(), e);
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Failed in user operation", (Map)ImmutableMap.builder().putAll(TraceUtil.getExceptionAnnotations(toThrow)).put((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())).build());
                    throw toThrow;
                }
                finally {
                    if (shouldRollback) {
                        TransactionRunnerImpl.this.txn.rollback();
                    }
                }
                try {
                    TransactionRunnerImpl.this.txn.commit();
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Succeeded", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                    return result;
                }
                catch (AbortedException e) {
                    txnLogger.log(Level.FINE, "Commit aborted", (Throwable)((Object)e));
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Aborted in Commit. Retrying", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                    throw e;
                }
                catch (SpannerException e) {
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Failed in Commit", (Map)ImmutableMap.builder().putAll(TraceUtil.getExceptionAnnotations(e)).put((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())).build());
                    throw e;
                }
            }
        };
        return SpannerRetryHelper.runTxWithRetriesOnAborted(retryCallable);
    }

    @Override
    public Timestamp getCommitTimestamp() {
        Preconditions.checkState((this.txn != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
        return this.txn.commitTimestamp();
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @VisibleForTesting
    static class TransactionContextImpl
    extends AbstractReadContext
    implements TransactionContext {
        @GuardedBy(value="lock")
        private volatile boolean committing;
        @GuardedBy(value="lock")
        private volatile SettableApiFuture<Void> finishedAsyncOperations = SettableApiFuture.create();
        @GuardedBy(value="lock")
        private volatile int runningAsyncOperations;
        @GuardedBy(value="lock")
        private List<Mutation> mutations = new ArrayList<Mutation>();
        @GuardedBy(value="lock")
        private boolean aborted;
        @GuardedBy(value="lock")
        private long retryDelayInMillis = -1L;
        private ByteString transactionId;
        private Timestamp commitTimestamp;

        static Builder newBuilder() {
            return new Builder();
        }

        private TransactionContextImpl(Builder builder) {
            super(builder);
            this.transactionId = builder.transactionId;
            this.finishedAsyncOperations.set(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void increaseAsynOperations() {
            Object object = this.lock;
            synchronized (object) {
                if (this.runningAsyncOperations == 0) {
                    this.finishedAsyncOperations = SettableApiFuture.create();
                }
                ++this.runningAsyncOperations;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decreaseAsyncOperations() {
            Object object = this.lock;
            synchronized (object) {
                --this.runningAsyncOperations;
                if (this.runningAsyncOperations == 0) {
                    this.finishedAsyncOperations.set(null);
                }
            }
        }

        void ensureTxn() {
            try {
                this.ensureTxnAsync().get();
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }

        ApiFuture<Void> ensureTxnAsync() {
            final SettableApiFuture res = SettableApiFuture.create();
            if (this.transactionId == null || this.isAborted()) {
                this.span.addAnnotation("Creating Transaction");
                final ApiFuture<ByteString> fut = this.session.beginTransactionAsync();
                fut.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TransactionContextImpl.this.transactionId = (ByteString)fut.get();
                            TransactionContextImpl.this.span.addAnnotation("Transaction Creation Done", (Map)ImmutableMap.of((Object)"Id", (Object)AttributeValue.stringAttributeValue((String)TransactionContextImpl.this.transactionId.toStringUtf8())));
                            txnLogger.log(Level.FINER, "Started transaction {0}", txnLogger.isLoggable(Level.FINER) ? TransactionContextImpl.this.transactionId.asReadOnlyByteBuffer() : null);
                            res.set(null);
                        }
                        catch (ExecutionException e) {
                            TransactionContextImpl.this.span.addAnnotation("Transaction Creation Failed", TraceUtil.getExceptionAnnotations(e.getCause() == null ? e : e.getCause()));
                            res.setException(e.getCause() == null ? e : e.getCause());
                        }
                        catch (InterruptedException e) {
                            res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                        }
                    }
                }, MoreExecutors.directExecutor());
            } else {
                this.span.addAnnotation("Transaction Initialized", (Map)ImmutableMap.of((Object)"Id", (Object)AttributeValue.stringAttributeValue((String)this.transactionId.toStringUtf8())));
                txnLogger.log(Level.FINER, "Using prepared transaction {0}", txnLogger.isLoggable(Level.FINER) ? this.transactionId.asReadOnlyByteBuffer() : null);
                res.set(null);
            }
            return res;
        }

        void commit() {
            try {
                this.commitTimestamp = (Timestamp)this.commitAsync().get();
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ApiFuture<Timestamp> commitAsync() {
            SettableApiFuture<Void> latch;
            final SettableApiFuture res = SettableApiFuture.create();
            Object object = this.lock;
            synchronized (object) {
                latch = this.finishedAsyncOperations;
            }
            latch.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        latch.get();
                        CommitRequest.Builder builder = CommitRequest.newBuilder().setSession(TransactionContextImpl.this.session.getName()).setTransactionId(TransactionContextImpl.this.transactionId);
                        Object object = TransactionContextImpl.this.lock;
                        synchronized (object) {
                            if (!TransactionContextImpl.this.mutations.isEmpty()) {
                                ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
                                Mutation.toProto(TransactionContextImpl.this.mutations, mutationsProto);
                                builder.addAllMutations(mutationsProto);
                            }
                            TransactionContextImpl.this.mutations = null;
                        }
                        CommitRequest commitRequest = builder.build();
                        TransactionContextImpl.this.span.addAnnotation("Starting Commit");
                        final Span opSpan = tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.Commit", TransactionContextImpl.this.span).startSpan();
                        final ApiFuture<CommitResponse> commitFuture = TransactionContextImpl.this.rpc.commitAsync(commitRequest, TransactionContextImpl.this.session.getOptions());
                        commitFuture.addListener(tracer.withSpan(opSpan, new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CommitResponse commitResponse = (CommitResponse)commitFuture.get();
                                    if (!commitResponse.hasCommitTimestamp()) {
                                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing commitTimestamp:\n" + TransactionContextImpl.this.session.getName());
                                    }
                                    Timestamp ts = Timestamp.fromProto((com.google.protobuf.Timestamp)commitResponse.getCommitTimestamp());
                                    TransactionContextImpl.this.span.addAnnotation("Commit Done");
                                    opSpan.end(TraceUtil.END_SPAN_OPTIONS);
                                    res.set((Object)ts);
                                }
                                catch (Throwable e2) {
                                    SpannerException e2 = e2 instanceof ExecutionException ? SpannerExceptionFactory.newSpannerException(e2.getCause() == null ? e2 : e2.getCause()) : (e2 instanceof InterruptedException ? SpannerExceptionFactory.propagateInterrupt((InterruptedException)e2) : SpannerExceptionFactory.newSpannerException(e2));
                                    TransactionContextImpl.this.span.addAnnotation("Commit Failed", TraceUtil.getExceptionAnnotations((Throwable)((Object)e2)));
                                    TraceUtil.endSpanWithFailure(opSpan, (Throwable)((Object)e2));
                                    TransactionContextImpl.this.onError(e2);
                                    res.setException((Throwable)((Object)e2));
                                }
                            }
                        }), MoreExecutors.directExecutor());
                    }
                    catch (InterruptedException e) {
                        res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                    }
                    catch (ExecutionException e) {
                        res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
                    }
                }
            }, MoreExecutors.directExecutor());
            return res;
        }

        Timestamp commitTimestamp() {
            Preconditions.checkState((this.commitTimestamp != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
            return this.commitTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAborted() {
            Object object = this.lock;
            synchronized (object) {
                return this.aborted;
            }
        }

        void rollback() {
            try {
                this.span.addAnnotation("Starting Rollback");
                this.rpc.rollback(RollbackRequest.newBuilder().setSession(this.session.getName()).setTransactionId(this.transactionId).build(), this.session.getOptions());
                this.span.addAnnotation("Rollback Done");
            }
            catch (SpannerException e) {
                txnLogger.log(Level.FINE, "Exception during rollback", (Throwable)((Object)e));
                this.span.addAnnotation("Rollback Failed", TraceUtil.getExceptionAnnotations(e));
            }
        }

        ApiFuture<Void> rollbackAsync() {
            this.span.addAnnotation("Starting Rollback");
            return ApiFutures.transformAsync(this.rpc.rollbackAsync(RollbackRequest.newBuilder().setSession(this.session.getName()).setTransactionId(this.transactionId).build(), this.session.getOptions()), (ApiAsyncFunction)new ApiAsyncFunction<Empty, Void>(){

                public ApiFuture<Void> apply(Empty input) throws Exception {
                    TransactionContextImpl.this.span.addAnnotation("Rollback Done");
                    return ApiFutures.immediateFuture(null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            return TransactionSelector.newBuilder().setId(this.transactionId).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(SpannerException e) {
            if (e.getErrorCode() == ErrorCode.ABORTED) {
                long delay = -1L;
                if (e instanceof AbortedException) {
                    delay = ((AbortedException)e).getRetryDelayInMillis();
                }
                if (delay == -1L) {
                    txnLogger.log(Level.FINE, "Retry duration is missing from the exception.", (Throwable)((Object)e));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.retryDelayInMillis = delay;
                    this.aborted = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Mutation mutation) {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkNotNull(this.mutations, (Object)"Context is closed");
                this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Iterable<Mutation> mutations) {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkNotNull(this.mutations, (Object)"Context is closed");
                for (Mutation mutation : mutations) {
                    this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
                }
            }
        }

        @Override
        public long executeUpdate(Statement statement) {
            this.beforeReadOrQuery();
            ExecuteSqlRequest.Builder builder = this.getExecuteSqlRequestBuilder(statement, ExecuteSqlRequest.QueryMode.NORMAL);
            try {
                ResultSet resultSet = this.rpc.executeQuery(builder.build(), this.session.getOptions());
                if (!resultSet.hasStats()) {
                    throw new IllegalArgumentException("DML response missing stats possibly due to non-DML statement as input");
                }
                return resultSet.getStats().getRowCountExact();
            }
            catch (SpannerException e) {
                this.onError(e);
                throw e;
            }
        }

        @Override
        public ApiFuture<Long> executeUpdateAsync(Statement statement) {
            ApiFuture<ResultSet> resultSet;
            this.beforeReadOrQuery();
            ExecuteSqlRequest.Builder builder = this.getExecuteSqlRequestBuilder(statement, ExecuteSqlRequest.QueryMode.NORMAL);
            try {
                this.increaseAsynOperations();
                resultSet = this.rpc.executeQueryAsync(builder.build(), this.session.getOptions());
            }
            catch (Throwable t) {
                this.decreaseAsyncOperations();
                throw t;
            }
            ApiFuture updateCount = ApiFutures.transform(resultSet, (ApiFunction)new ApiFunction<ResultSet, Long>(){

                public Long apply(ResultSet input) {
                    if (!input.hasStats()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "DML response missing stats possibly due to non-DML statement as input");
                    }
                    return input.getStats().getRowCountExact();
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCount = ApiFutures.catching((ApiFuture)updateCount, Throwable.class, (ApiFunction)new ApiFunction<Throwable, Long>(){

                public Long apply(Throwable input) {
                    SpannerException e = SpannerExceptionFactory.newSpannerException(input);
                    TransactionContextImpl.this.onError(e);
                    throw e;
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCount.addListener(new Runnable(){

                @Override
                public void run() {
                    TransactionContextImpl.this.decreaseAsyncOperations();
                }
            }, MoreExecutors.directExecutor());
            return updateCount;
        }

        @Override
        public long[] batchUpdate(Iterable<Statement> statements) {
            this.beforeReadOrQuery();
            ExecuteBatchDmlRequest.Builder builder = this.getExecuteBatchDmlRequestBuilder(statements);
            try {
                ExecuteBatchDmlResponse response = this.rpc.executeBatchDml(builder.build(), this.session.getOptions());
                long[] results = new long[response.getResultSetsCount()];
                for (int i = 0; i < response.getResultSetsCount(); ++i) {
                    results[i] = response.getResultSets(i).getStats().getRowCountExact();
                }
                if (response.getStatus().getCode() == 10) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.fromRpcStatus(response.getStatus()), response.getStatus().getMessage());
                }
                if (response.getStatus().getCode() != 0) {
                    throw SpannerExceptionFactory.newSpannerBatchUpdateException(ErrorCode.fromRpcStatus(response.getStatus()), response.getStatus().getMessage(), results);
                }
                return results;
            }
            catch (SpannerException e) {
                this.onError(e);
                throw e;
            }
        }

        @Override
        public ApiFuture<long[]> batchUpdateAsync(Iterable<Statement> statements) {
            ApiFuture<ExecuteBatchDmlResponse> response;
            this.beforeReadOrQuery();
            ExecuteBatchDmlRequest.Builder builder = this.getExecuteBatchDmlRequestBuilder(statements);
            try {
                this.increaseAsynOperations();
                response = this.rpc.executeBatchDmlAsync(builder.build(), this.session.getOptions());
            }
            catch (Throwable t) {
                this.decreaseAsyncOperations();
                throw t;
            }
            ApiFuture updateCounts = ApiFutures.transform(response, (ApiFunction)new ApiFunction<ExecuteBatchDmlResponse, long[]>(){

                public long[] apply(ExecuteBatchDmlResponse input) {
                    long[] results = new long[input.getResultSetsCount()];
                    for (int i = 0; i < input.getResultSetsCount(); ++i) {
                        results[i] = input.getResultSets(i).getStats().getRowCountExact();
                    }
                    if (input.getStatus().getCode() == 10) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.fromRpcStatus(input.getStatus()), input.getStatus().getMessage());
                    }
                    if (input.getStatus().getCode() != 0) {
                        throw SpannerExceptionFactory.newSpannerBatchUpdateException(ErrorCode.fromRpcStatus(input.getStatus()), input.getStatus().getMessage(), results);
                    }
                    return results;
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCounts = ApiFutures.catching((ApiFuture)updateCounts, Throwable.class, (ApiFunction)new ApiFunction<Throwable, long[]>(){

                public long[] apply(Throwable input) {
                    SpannerException e = SpannerExceptionFactory.newSpannerException(input);
                    TransactionContextImpl.this.onError(e);
                    throw e;
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCounts.addListener(new Runnable(){

                @Override
                public void run() {
                    TransactionContextImpl.this.decreaseAsyncOperations();
                }
            }, MoreExecutors.directExecutor());
            return updateCounts;
        }

        private AbstractReadContext.ListenableAsyncResultSet wrap(AbstractReadContext.ListenableAsyncResultSet delegate) {
            return new TransactionContextAsyncResultSetImpl(delegate);
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap((AbstractReadContext.ListenableAsyncResultSet)super.readAsync(table, keys, (Iterable)columns, options));
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap((AbstractReadContext.ListenableAsyncResultSet)super.readUsingIndexAsync(table, index, keys, (Iterable)columns, options));
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return this.wrap(super.executeQueryAsync(statement, options));
        }

        private class TransactionContextAsyncResultSetImpl
        extends ForwardingAsyncResultSet
        implements AbstractReadContext.ListenableAsyncResultSet {
            private TransactionContextAsyncResultSetImpl(AbstractReadContext.ListenableAsyncResultSet delegate) {
                super(delegate);
            }

            @Override
            public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
                Runnable listener = new Runnable(){

                    @Override
                    public void run() {
                        TransactionContextImpl.this.decreaseAsyncOperations();
                    }
                };
                try {
                    TransactionContextImpl.this.increaseAsynOperations();
                    this.addListener(listener);
                    return super.setCallback(exec, cb);
                }
                catch (Throwable t) {
                    this.removeListener(listener);
                    TransactionContextImpl.this.decreaseAsyncOperations();
                    throw t;
                }
            }

            @Override
            public void addListener(Runnable listener) {
                ((AbstractReadContext.ListenableAsyncResultSet)this.delegate).addListener(listener);
            }

            @Override
            public void removeListener(Runnable listener) {
                ((AbstractReadContext.ListenableAsyncResultSet)this.delegate).removeListener(listener);
            }
        }

        static class Builder
        extends AbstractReadContext.Builder<Builder, TransactionContextImpl> {
            private ByteString transactionId;

            private Builder() {
            }

            Builder setTransactionId(ByteString transactionId) {
                this.transactionId = transactionId;
                return (Builder)this.self();
            }

            @Override
            TransactionContextImpl build() {
                return new TransactionContextImpl(this);
            }
        }
    }
}

