/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingStructReader;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.ResultSetStats;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

class AsyncResultSetImpl
extends ForwardingStructReader
implements AbstractReadContext.ListenableAsyncResultSet {
    private static final Logger log = Logger.getLogger(AsyncResultSetImpl.class.getName());
    static final int DEFAULT_BUFFER_SIZE = 10;
    private static final int MAX_WAIT_FOR_BUFFER_CONSUMPTION = 10;
    private static final SpannerException CANCELLED_EXCEPTION = SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "This AsyncResultSet has been cancelled");
    private final Object monitor = new Object();
    private boolean closed;
    private final ExecutorProvider executorProvider;
    private final ListeningScheduledExecutorService service;
    private final BlockingDeque<Struct> buffer;
    private Struct currentRow;
    private final ResultSet delegateResultSet;
    private volatile SpannerException executionException;
    private Executor executor;
    private AsyncResultSet.ReadyCallback callback;
    private Collection<Runnable> listeners = new LinkedList<Runnable>();
    private State state = State.INITIALIZED;
    private volatile boolean finished;
    private volatile ApiFuture<Void> result;
    private volatile boolean cursorReturnedDoneOrException;
    private volatile CountDownLatch pausedLatch = new CountDownLatch(1);
    private volatile CountDownLatch bufferConsumptionLatch = new CountDownLatch(0);
    private volatile CountDownLatch consumingLatch = new CountDownLatch(0);
    private final CallbackRunnable callbackRunnable = new CallbackRunnable();

    AsyncResultSetImpl(ExecutorProvider executorProvider, ResultSet delegate, int bufferSize) {
        super(delegate);
        this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
        this.delegateResultSet = (ResultSet)Preconditions.checkNotNull((Object)delegate);
        this.service = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorProvider.getExecutor());
        this.buffer = new LinkedBlockingDeque<Struct>(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.state == State.INITIALIZED || this.state == State.SYNC) {
                this.delegateResultSet.close();
            }
            this.closed = true;
        }
    }

    @Override
    public void addListener(Runnable listener) {
        Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Runnable listener) {
        Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0);
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResultSet.CursorState tryNext() throws SpannerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == State.CANCELLED) {
                this.cursorReturnedDoneOrException = true;
                throw CANCELLED_EXCEPTION;
            }
            if (this.buffer.isEmpty() && this.executionException != null) {
                this.cursorReturnedDoneOrException = true;
                throw this.executionException;
            }
            Preconditions.checkState((this.callback != null ? 1 : 0) != 0, (Object)"tryNext may only be called after a callback has been set.");
            Preconditions.checkState((this.state == State.CONSUMING ? 1 : 0) != 0, (Object)("tryNext may only be called from a DataReady callback. Current state: " + this.state.name()));
            if (this.finished && this.buffer.isEmpty()) {
                this.cursorReturnedDoneOrException = true;
                return AsyncResultSet.CursorState.DONE;
            }
        }
        if (!this.buffer.isEmpty()) {
            this.currentRow = (Struct)this.buffer.pop();
            this.replaceDelegate(this.currentRow);
            object = this.monitor;
            synchronized (object) {
                this.bufferConsumptionLatch.countDown();
            }
            return AsyncResultSet.CursorState.OK;
        }
        return AsyncResultSet.CursorState.NOT_READY;
    }

    private void closeDelegateResultSet() {
        try {
            this.delegateResultSet.close();
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Ignoring error from closing delegate result set", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"This AsyncResultSet has been closed");
            Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0, (Object)"callback may not be set multiple times");
            this.result = new ListenableFutureToApiFuture(this.service.submit((Callable)new ProduceRowsCallable()));
            this.executor = MoreExecutors.newSequentialExecutor((Executor)((Executor)Preconditions.checkNotNull((Object)exec)));
            this.callback = (AsyncResultSet.ReadyCallback)Preconditions.checkNotNull((Object)cb);
            this.state = State.RUNNING;
            this.pausedLatch.countDown();
            return this.result;
        }
    }

    Future<Void> getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state != State.INITIALIZED && this.state != State.SYNC ? 1 : 0) != 0, (Object)"cannot cancel a result set without a callback");
            this.state = State.CANCELLED;
            this.pausedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state != State.INITIALIZED && this.state != State.SYNC ? 1 : 0) != 0, (Object)"cannot resume a result set without a callback");
            if (this.state == State.PAUSED) {
                this.state = State.RUNNING;
                this.pausedLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ApiFuture<List<T>> toListAsync(Function<StructReader, T> transformer, Executor executor) {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"This AsyncResultSet has been closed");
            Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0, (Object)"This AsyncResultSet has already been used.");
            final SettableApiFuture res = SettableApiFuture.create();
            CreateListCallback callback = new CreateListCallback(res, transformer);
            ApiFuture<Void> finished = this.setCallback(executor, callback);
            return ApiFutures.transformAsync(finished, (ApiAsyncFunction)new ApiAsyncFunction<Void, List<T>>(){

                public ApiFuture<List<T>> apply(Void input) throws Exception {
                    return res;
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    @Override
    public <T> List<T> toList(Function<StructReader, T> transformer) throws SpannerException {
        ApiFuture<List<T>> future = this.toListAsync(transformer, MoreExecutors.directExecutor());
        try {
            return (List)future.get();
        }
        catch (ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(e.getCause());
        }
        catch (Throwable e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SpannerException {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SYNC ? 1 : 0) != 0, (Object)"Cannot call next() on a result set with a callback.");
            this.state = State.SYNC;
        }
        boolean res = this.delegateResultSet.next();
        this.currentRow = res ? this.delegateResultSet.getCurrentRowAsStruct() : null;
        return res;
    }

    @Override
    public ResultSetStats getStats() {
        return this.delegateResultSet.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkValidState() {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state == State.SYNC || this.state == State.CONSUMING || this.state == State.CANCELLED ? 1 : 0) != 0, (Object)"only allowed after a next() call or from within a ReadyCallback#cursorReady callback");
            Preconditions.checkState((this.state != State.SYNC || !this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
        }
    }

    @Override
    public Struct getCurrentRowAsStruct() {
        this.checkValidState();
        return this.currentRow;
    }

    static /* synthetic */ AsyncResultSet.ReadyCallback access$200(AsyncResultSetImpl x0) {
        return x0.callback;
    }

    static /* synthetic */ boolean access$102(AsyncResultSetImpl x0, boolean x1) {
        x0.cursorReturnedDoneOrException = x1;
        return x0.cursorReturnedDoneOrException;
    }

    static /* synthetic */ CountDownLatch access$502(AsyncResultSetImpl x0, CountDownLatch x1) {
        x0.pausedLatch = x1;
        return x0.pausedLatch;
    }

    static /* synthetic */ boolean access$700(AsyncResultSetImpl x0) {
        return x0.finished;
    }

    private static class CreateListCallback<T>
    implements AsyncResultSet.ReadyCallback {
        private final SettableApiFuture<List<T>> future;
        private final Function<StructReader, T> transformer;
        private final ImmutableList.Builder<T> builder = ImmutableList.builder();

        private CreateListCallback(SettableApiFuture<List<T>> future, Function<StructReader, T> transformer) {
            this.future = future;
            this.transformer = transformer;
        }

        @Override
        public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
            try {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case DONE: {
                            this.future.set((Object)this.builder.build());
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case OK: {
                            this.builder.add(this.transformer.apply((Object)resultSet));
                        }
                    }
                }
            }
            catch (Throwable t) {
                this.future.setException(t);
                return AsyncResultSet.CallbackResponse.DONE;
            }
        }
    }

    private class ProduceRowsCallable
    implements Callable<Void> {
        private ProduceRowsCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws Exception {
            Object object;
            Object object2;
            boolean stop = false;
            boolean hasNext = false;
            try {
                hasNext = AsyncResultSetImpl.this.delegateResultSet.next();
            }
            catch (Throwable e) {
                object2 = AsyncResultSetImpl.this.monitor;
                // MONITORENTER : object2
                AsyncResultSetImpl.this.executionException = SpannerExceptionFactory.newSpannerException(e);
                // MONITOREXIT : object2
            }
            try {
                while (!stop && hasNext) {
                    try {
                        Object e = AsyncResultSetImpl.this.monitor;
                        // MONITORENTER : e
                        stop = AsyncResultSetImpl.this.state.shouldStop;
                        // MONITOREXIT : e
                        if (!stop) {
                            while (AsyncResultSetImpl.this.buffer.remainingCapacity() == 0 && !stop) {
                                this.waitIfPaused();
                                this.startCallbackWithBufferLatchIfNecessary(Math.min(Math.min(AsyncResultSetImpl.this.buffer.size() / 2 + 1, AsyncResultSetImpl.this.buffer.size()), 10));
                                AsyncResultSetImpl.this.bufferConsumptionLatch.await();
                                e = AsyncResultSetImpl.this.monitor;
                                // MONITORENTER : e
                                stop = AsyncResultSetImpl.this.state.shouldStop;
                                // MONITOREXIT : e
                            }
                        }
                        if (stop) continue;
                        AsyncResultSetImpl.this.buffer.put(AsyncResultSetImpl.this.delegateResultSet.getCurrentRowAsStruct());
                        this.startCallbackIfNecessary();
                        hasNext = AsyncResultSetImpl.this.delegateResultSet.next();
                    }
                    catch (Throwable e) {
                        object2 = AsyncResultSetImpl.this.monitor;
                        // MONITORENTER : object2
                        AsyncResultSetImpl.this.executionException = SpannerExceptionFactory.newSpannerException(e);
                        stop = true;
                        // MONITOREXIT : object2
                    }
                }
                AsyncResultSetImpl.this.closeDelegateResultSet();
                object = AsyncResultSetImpl.this.monitor;
                // MONITORENTER : object
                AsyncResultSetImpl.this.finished = true;
                stop = AsyncResultSetImpl.this.cursorReturnedDoneOrException;
                // MONITOREXIT : object
                while (!stop) {
                    this.waitIfPaused();
                    this.startCallbackIfNecessary();
                    AsyncResultSetImpl.this.consumingLatch.await();
                    object = AsyncResultSetImpl.this.monitor;
                    // MONITORENTER : object
                    stop = AsyncResultSetImpl.this.cursorReturnedDoneOrException;
                    // MONITOREXIT : object
                }
            }
            catch (Throwable throwable) {
                if (AsyncResultSetImpl.this.executorProvider.shouldAutoClose()) {
                    AsyncResultSetImpl.this.service.shutdown();
                }
                for (Runnable listener : AsyncResultSetImpl.this.listeners) {
                    listener.run();
                }
                Object object3 = AsyncResultSetImpl.this.monitor;
                // MONITORENTER : object3
                if (AsyncResultSetImpl.this.executionException != null) {
                    throw AsyncResultSetImpl.this.executionException;
                }
                if (AsyncResultSetImpl.this.state == State.CANCELLED) {
                    throw CANCELLED_EXCEPTION;
                }
                // MONITOREXIT : object3
                throw throwable;
            }
            if (AsyncResultSetImpl.this.executorProvider.shouldAutoClose()) {
                AsyncResultSetImpl.this.service.shutdown();
            }
            for (Runnable listener : AsyncResultSetImpl.this.listeners) {
                listener.run();
            }
            object = AsyncResultSetImpl.this.monitor;
            // MONITORENTER : object
            if (AsyncResultSetImpl.this.executionException != null) {
                throw AsyncResultSetImpl.this.executionException;
            }
            if (AsyncResultSetImpl.this.state == State.CANCELLED) {
                throw CANCELLED_EXCEPTION;
            }
            // MONITOREXIT : object
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitIfPaused() throws InterruptedException {
            CountDownLatch pause;
            Object object = AsyncResultSetImpl.this.monitor;
            synchronized (object) {
                pause = AsyncResultSetImpl.this.pausedLatch;
            }
            pause.await();
        }

        private void startCallbackIfNecessary() {
            this.startCallbackWithBufferLatchIfNecessary(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startCallbackWithBufferLatchIfNecessary(int bufferLatch) {
            Object object = AsyncResultSetImpl.this.monitor;
            synchronized (object) {
                if (!(AsyncResultSetImpl.this.state != State.RUNNING && AsyncResultSetImpl.this.state != State.CANCELLED || AsyncResultSetImpl.this.cursorReturnedDoneOrException)) {
                    AsyncResultSetImpl.this.consumingLatch = new CountDownLatch(1);
                    if (bufferLatch > 0) {
                        AsyncResultSetImpl.this.bufferConsumptionLatch = new CountDownLatch(bufferLatch);
                    }
                    if (AsyncResultSetImpl.this.state == State.RUNNING) {
                        AsyncResultSetImpl.this.state = State.CONSUMING;
                    }
                    AsyncResultSetImpl.this.executor.execute(AsyncResultSetImpl.this.callbackRunnable);
                }
            }
        }
    }

    private class CallbackRunnable
    implements Runnable {
        private CallbackRunnable() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 33[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static enum State {
        INITIALIZED,
        SYNC,
        CONSUMING,
        RUNNING,
        PAUSED,
        CANCELLED(true),
        DONE(true);

        private final boolean shouldStop;

        private State() {
            this.shouldStop = false;
        }

        private State(boolean shouldStop) {
            this.shouldStop = shouldStop;
        }
    }
}

