/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;

class DdlBatch
extends AbstractBaseUnitOfWork {
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final List<String> statements = new ArrayList<String>();
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private static final StatementParser.ParsedStatement RUN_BATCH = StatementParser.INSTANCE.parse(Statement.of("RUN BATCH"));

    static Builder newBuilder() {
        return new Builder();
    }

    private DdlBatch(Builder builder) {
        super(builder);
        this.ddlClient = builder.ddlClient;
        this.dbClient = builder.dbClient;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.BATCH;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultSet executeQuery(final StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!(options[i] instanceof Connection.InternalMetadataQuery)) continue;
                Preconditions.checkNotNull((Object)statement);
                Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
                Preconditions.checkArgument((analyzeMode == AnalyzeMode.NONE ? 1 : 0) != 0, (Object)"Analyze is not allowed for DDL batch");
                final Options.QueryOption[] internalOptions = (Options.QueryOption[])ArrayUtils.remove((Object[])options, (int)i);
                Callable<ResultSet> callable = new Callable<ResultSet>(){

                    @Override
                    public ResultSet call() throws Exception {
                        return DirectExecuteResultSet.ofResultSet(DdlBatch.this.dbClient.singleUse().executeQuery(statement.getStatement(), internalOptions));
                    }
                };
                return this.asyncExecuteStatement(statement, callable);
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing queries is not allowed for DDL batches.");
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for DDL batches.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for DDL batches.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public void executeDdl(StatementParser.ParsedStatement ddl) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be used for further statements");
        Preconditions.checkArgument((ddl.getType() == StatementParser.StatementType.DDL ? 1 : 0) != 0, (Object)("Only DDL statements are allowed. \"" + ddl.getSqlWithoutComments() + "\" is not a DDL-statement."));
        this.statements.add(ddl.getSqlWithoutComments());
    }

    @Override
    public long executeUpdate(StatementParser.ParsedStatement update) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing updates is not allowed for DDL batches.");
    }

    @Override
    public long[] executeBatchUpdate(Iterable<StatementParser.ParsedStatement> updates) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing batch updates is not allowed for DDL batches.");
    }

    @Override
    public void write(Mutation mutation) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DDL batches.");
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DDL batches.");
    }

    @Override
    public long[] runBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be ran");
        try {
            if (!this.statements.isEmpty()) {
                Callable<UpdateDatabaseDdlMetadata> callable = new Callable<UpdateDatabaseDdlMetadata>(){

                    @Override
                    public UpdateDatabaseDdlMetadata call() throws Exception {
                        OperationFuture<Void, UpdateDatabaseDdlMetadata> operation = DdlBatch.this.ddlClient.executeDdl(DdlBatch.this.statements);
                        try {
                            operation.get();
                            return (UpdateDatabaseDdlMetadata)operation.getMetadata().get();
                        }
                        catch (ExecutionException e) {
                            SpannerException spannerException = DdlBatch.this.extractSpannerCause(e);
                            long[] updateCounts = DdlBatch.this.extractUpdateCounts((UpdateDatabaseDdlMetadata)operation.getMetadata().get());
                            throw SpannerExceptionFactory.newSpannerBatchUpdateException(spannerException == null ? ErrorCode.UNKNOWN : spannerException.getErrorCode(), e.getMessage(), updateCounts);
                        }
                        catch (InterruptedException e) {
                            long[] updateCounts = DdlBatch.this.extractUpdateCounts((UpdateDatabaseDdlMetadata)operation.getMetadata().get());
                            throw SpannerExceptionFactory.newSpannerBatchUpdateException(ErrorCode.CANCELLED, e.getMessage(), updateCounts);
                        }
                    }
                };
                this.asyncExecuteStatement(RUN_BATCH, callable);
            }
            this.state = UnitOfWork.UnitOfWorkState.RAN;
            long[] updateCounts = new long[this.statements.size()];
            Arrays.fill(updateCounts, 1L);
            return updateCounts;
        }
        catch (SpannerException e) {
            this.state = UnitOfWork.UnitOfWorkState.RUN_FAILED;
            throw e;
        }
    }

    private SpannerException extractSpannerCause(ExecutionException e) {
        HashSet<Throwable> causes = new HashSet<Throwable>();
        for (Throwable cause = e.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
            if (cause instanceof SpannerException) {
                return (SpannerException)((Object)cause);
            }
            causes.add(cause);
        }
        return null;
    }

    @VisibleForTesting
    long[] extractUpdateCounts(UpdateDatabaseDdlMetadata metadata) {
        long[] updateCounts = new long[metadata.getStatementsCount()];
        for (int i = 0; i < updateCounts.length; ++i) {
            updateCounts[i] = metadata.getCommitTimestampsCount() > i && metadata.getCommitTimestamps(i) != null ? 1L : 0L;
        }
        return updateCounts;
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be aborted.");
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    public void commit() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not allowed for DDL batches.");
    }

    @Override
    public void rollback() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not allowed for DDL batches.");
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, DdlBatch> {
        private DdlClient ddlClient;
        private DatabaseClient dbClient;

        private Builder() {
        }

        Builder setDdlClient(DdlClient client) {
            Preconditions.checkNotNull((Object)client);
            this.ddlClient = client;
            return this;
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        @Override
        DdlBatch build() {
            Preconditions.checkState((this.ddlClient != null ? 1 : 0) != 0, (Object)"No DdlClient specified");
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DbClient specified");
            return new DdlBatch(this);
        }
    }
}

