/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.WatchdogTimeoutException;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceNotFoundException;
import com.google.cloud.spanner.IsRetryableInternalError;
import com.google.cloud.spanner.IsSslHandshakeException;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.protobuf.Message;
import com.google.rpc.ResourceInfo;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public final class SpannerExceptionFactory {
    static final String SESSION_RESOURCE_TYPE = "type.googleapis.com/google.spanner.v1.Session";
    static final String DATABASE_RESOURCE_TYPE = "type.googleapis.com/google.spanner.admin.database.v1.Database";
    static final String INSTANCE_RESOURCE_TYPE = "type.googleapis.com/google.spanner.admin.instance.v1.Instance";
    private static final Metadata.Key<ResourceInfo> KEY_RESOURCE_INFO = ProtoUtils.keyForProto((Message)ResourceInfo.getDefaultInstance());

    public static SpannerException newSpannerException(ErrorCode code, @Nullable String message) {
        return SpannerExceptionFactory.newSpannerException(code, message, null);
    }

    public static SpannerException newSpannerException(ErrorCode code, @Nullable String message, @Nullable Throwable cause) {
        return SpannerExceptionFactory.newSpannerExceptionPreformatted(code, SpannerExceptionFactory.formatMessage(code, message), cause);
    }

    public static SpannerException propagateInterrupt(InterruptedException e) {
        Thread.currentThread().interrupt();
        return SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Interrupted", e);
    }

    public static SpannerException propagateTimeout(TimeoutException e) {
        return SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Operation did not complete in the given time", e);
    }

    public static SpannerException asSpannerException(Throwable t) {
        if (t instanceof SpannerException) {
            return (SpannerException)((Object)t);
        }
        return SpannerExceptionFactory.newSpannerException(t);
    }

    public static SpannerException newSpannerException(Throwable cause) {
        return SpannerExceptionFactory.newSpannerException(null, cause);
    }

    public static SpannerBatchUpdateException newSpannerBatchUpdateException(ErrorCode code, String message, long[] updateCounts) {
        SpannerException.DoNotConstructDirectly token = SpannerException.DoNotConstructDirectly.ALLOWED;
        return new SpannerBatchUpdateException(token, code, message, updateCounts);
    }

    public static AbortedDueToConcurrentModificationException newAbortedDueToConcurrentModificationException(AbortedException cause) {
        return new AbortedDueToConcurrentModificationException(SpannerException.DoNotConstructDirectly.ALLOWED, "The transaction was aborted and could not be retried due to a concurrent modification", (Throwable)((Object)cause));
    }

    public static AbortedDueToConcurrentModificationException newAbortedDueToConcurrentModificationException(AbortedException cause, SpannerException databaseError) {
        return new AbortedDueToConcurrentModificationException(SpannerException.DoNotConstructDirectly.ALLOWED, "The transaction was aborted and could not be retried due to a database error during the retry", (Throwable)((Object)cause), databaseError);
    }

    public static AbortedDueToConcurrentModificationException newAbortedDueToConcurrentModificationException(AbortedDueToConcurrentModificationException cause) {
        return new AbortedDueToConcurrentModificationException(SpannerException.DoNotConstructDirectly.ALLOWED, "This transaction has already been aborted and could not be retried due to a concurrent modification. Rollback this transaction to start a new one.", (Throwable)((Object)cause));
    }

    public static SpannerException newSpannerException(@Nullable Context context, Throwable cause) {
        if (cause instanceof SpannerException) {
            SpannerException e = (SpannerException)((Object)cause);
            return SpannerExceptionFactory.newSpannerExceptionPreformatted(e.getErrorCode(), e.getMessage(), (Throwable)((Object)e));
        }
        if (cause instanceof CancellationException) {
            return SpannerExceptionFactory.newSpannerExceptionForCancellation(context, cause);
        }
        if (cause instanceof ApiException) {
            return SpannerExceptionFactory.fromApiException((ApiException)cause);
        }
        Status status = Status.fromThrowable((Throwable)cause);
        if (status.getCode() == Status.Code.CANCELLED) {
            return SpannerExceptionFactory.newSpannerExceptionForCancellation(context, cause);
        }
        return SpannerExceptionFactory.newSpannerException(ErrorCode.fromGrpcStatus(status), cause.getMessage(), cause);
    }

    static SpannerException newSpannerExceptionForCancellation(@Nullable Context context, @Nullable Throwable cause) {
        if (context != null && context.isCancelled()) {
            Throwable throwable;
            Throwable cancellationCause = context.cancellationCause();
            Throwable throwable2 = throwable = cause == null && cancellationCause == null ? null : (Throwable)MoreObjects.firstNonNull((Object)cause, (Object)cancellationCause);
            if (cancellationCause instanceof TimeoutException) {
                return SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Current context exceeded deadline", throwable);
            }
            return SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Current context was cancelled", throwable);
        }
        return SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, cause == null ? "Cancelled" : cause.getMessage(), cause);
    }

    private static String formatMessage(ErrorCode code, @Nullable String message) {
        if (message == null) {
            return code.toString();
        }
        return message.startsWith(code.toString()) ? message : (Object)((Object)code) + ": " + message;
    }

    private static ResourceInfo extractResourceInfo(Throwable cause) {
        Metadata trailers;
        if (cause != null && (trailers = Status.trailersFromThrowable((Throwable)cause)) != null) {
            return (ResourceInfo)trailers.get(KEY_RESOURCE_INFO);
        }
        return null;
    }

    static SpannerException newSpannerExceptionPreformatted(ErrorCode code, @Nullable String message, @Nullable Throwable cause) {
        SpannerException.DoNotConstructDirectly token = SpannerException.DoNotConstructDirectly.ALLOWED;
        switch (code) {
            case ABORTED: {
                return new AbortedException(token, message, cause);
            }
            case NOT_FOUND: {
                ResourceInfo resourceInfo = SpannerExceptionFactory.extractResourceInfo(cause);
                if (resourceInfo == null) break;
                if (resourceInfo.getResourceType().equals(SESSION_RESOURCE_TYPE)) {
                    return new SessionNotFoundException(token, message, resourceInfo, cause);
                }
                if (resourceInfo.getResourceType().equals(DATABASE_RESOURCE_TYPE)) {
                    return new DatabaseNotFoundException(token, message, resourceInfo, cause);
                }
                if (!resourceInfo.getResourceType().equals(INSTANCE_RESOURCE_TYPE)) break;
                return new InstanceNotFoundException(token, message, resourceInfo, cause);
            }
        }
        return new SpannerException(token, code, SpannerExceptionFactory.isRetryable(code, cause), message, cause);
    }

    private static SpannerException fromApiException(ApiException exception) {
        Status.Code code = exception.getStatusCode() instanceof GrpcStatusCode ? ((GrpcStatusCode)exception.getStatusCode()).getTransportCode() : (exception instanceof WatchdogTimeoutException ? Status.Code.DEADLINE_EXCEEDED : Status.Code.UNKNOWN);
        ErrorCode errorCode = ErrorCode.fromGrpcStatus(Status.fromCode((Status.Code)code));
        if (exception.getCause() != null) {
            return SpannerExceptionFactory.newSpannerException(errorCode, exception.getMessage(), exception.getCause());
        }
        return SpannerExceptionFactory.newSpannerException(errorCode, exception.getMessage());
    }

    private static boolean isRetryable(ErrorCode code, @Nullable Throwable cause) {
        switch (code) {
            case INTERNAL: {
                return SpannerExceptionFactory.hasCauseMatching(cause, Matchers.isRetryableInternalError);
            }
            case UNAVAILABLE: {
                return !SpannerExceptionFactory.hasCauseMatching(cause, Matchers.isSSLHandshakeException);
            }
            case RESOURCE_EXHAUSTED: {
                return SpannerException.extractRetryDelay(cause) > 0L;
            }
        }
        return false;
    }

    private static boolean hasCauseMatching(@Nullable Throwable cause, Predicate<? super Throwable> matcher) {
        while (cause != null) {
            if (matcher.apply((Object)cause)) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    private static class Matchers {
        static final Predicate<Throwable> isRetryableInternalError = new IsRetryableInternalError();
        static final Predicate<Throwable> isSSLHandshakeException = new IsSslHandshakeException();

        private Matchers() {
        }
    }
}

