/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.CredentialsService;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class ConnectionOptions {
    private static final boolean DEFAULT_USE_PLAIN_TEXT = false;
    static final boolean DEFAULT_AUTOCOMMIT = true;
    static final boolean DEFAULT_READONLY = false;
    static final boolean DEFAULT_RETRY_ABORTS_INTERNALLY = true;
    private static final String DEFAULT_CREDENTIALS = null;
    private static final String DEFAULT_OAUTH_TOKEN = null;
    private static final String DEFAULT_NUM_CHANNELS = null;
    private static final String DEFAULT_USER_AGENT = null;
    private static final String DEFAULT_OPTIMIZER_VERSION = "";
    private static final String PLAIN_TEXT_PROTOCOL = "http:";
    private static final String HOST_PROTOCOL = "https:";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final String USE_PLAIN_TEXT_PROPERTY_NAME = "usePlainText";
    public static final String AUTOCOMMIT_PROPERTY_NAME = "autocommit";
    public static final String READONLY_PROPERTY_NAME = "readonly";
    public static final String RETRY_ABORTS_INTERNALLY_PROPERTY_NAME = "retryAbortsInternally";
    public static final String CREDENTIALS_PROPERTY_NAME = "credentials";
    public static final String OAUTH_TOKEN_PROPERTY_NAME = "oauthToken";
    public static final String NUM_CHANNELS_PROPERTY_NAME = "numChannels";
    private static final String USER_AGENT_PROPERTY_NAME = "userAgent";
    private static final String OPTIMIZER_VERSION_PROPERTY_NAME = "optimizerVersion";
    public static final Set<ConnectionProperty> VALID_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Arrays.asList(ConnectionProperty.access$000("autocommit", "Should the connection start in autocommit (true/false)", true), ConnectionProperty.access$000("readonly", "Should the connection start in read-only mode (true/false)", false), ConnectionProperty.access$000("retryAbortsInternally", "Should the connection automatically retry Aborted errors (true/false)", true), ConnectionProperty.access$100("credentials", "The location of the credentials file to use for this connection. If this property is not set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("oauthToken", "A valid pre-existing OAuth token to use for authentication for this connection. Setting this property will take precedence over any value set for a credentials file."), ConnectionProperty.access$100("numChannels", "The number of gRPC channels to use to communicate with Cloud Spanner. The default is 4."), ConnectionProperty.access$000("usePlainText", "Use a plain text communication channel (i.e. non-TLS) for communicating with the server (true/false). Set this value to true for communication with the Cloud Spanner emulator.", false), ConnectionProperty.access$100("userAgent", "The custom user-agent property name to use when communicating with Cloud Spanner. This property is intended for internal library usage, and should not be set by applications."), ConnectionProperty.access$100("optimizerVersion", "Sets the default query optimizer version to use for this connection."))));
    private static final Set<ConnectionProperty> INTERNAL_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Arrays.asList(ConnectionProperty.access$100("userAgent", ""))));
    private static final Set<ConnectionProperty> INTERNAL_VALID_PROPERTIES = Sets.union(VALID_PROPERTIES, INTERNAL_PROPERTIES);
    private final String uri;
    private final String credentialsUrl;
    private final String oauthToken;
    private final Credentials fixedCredentials;
    private final boolean usePlainText;
    private final String host;
    private final String projectId;
    private final String instanceId;
    private final String databaseName;
    private final Credentials credentials;
    private final SessionPoolOptions sessionPoolOptions;
    private final Integer numChannels;
    private final String userAgent;
    private final ExecuteSqlRequest.QueryOptions queryOptions;
    private final boolean autocommit;
    private final boolean readOnly;
    private final boolean retryAbortsInternally;
    private final List<StatementExecutionInterceptor> statementExecutionInterceptors;
    private final SpannerOptionsConfigurator configurator;

    public static String getDefaultProjectId(Credentials credentials) {
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null && credentials != null && credentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)credentials).getProjectId();
        }
        return projectId;
    }

    public static void closeSpanner() {
        SpannerPool.INSTANCE.checkAndCloseSpanners();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConnectionOptions(Builder builder) {
        Matcher matcher = Builder.SPANNER_URI_PATTERN.matcher(builder.uri);
        Preconditions.checkArgument((boolean)matcher.find(), (Object)String.format("Invalid connection URI specified: %s", builder.uri));
        ConnectionOptions.checkValidProperties(builder.uri);
        this.uri = builder.uri;
        this.sessionPoolOptions = builder.sessionPoolOptions;
        this.credentialsUrl = builder.credentialsUrl != null ? builder.credentialsUrl : ConnectionOptions.parseCredentials(builder.uri);
        this.oauthToken = builder.oauthToken != null ? builder.oauthToken : ConnectionOptions.parseOAuthToken(builder.uri);
        this.fixedCredentials = builder.credentials;
        Preconditions.checkArgument((builder.credentials == null && this.credentialsUrl == null || this.oauthToken == null ? 1 : 0) != 0, (Object)"Cannot specify both credentials and an OAuth token.");
        this.usePlainText = ConnectionOptions.parseUsePlainText(this.uri);
        this.userAgent = ConnectionOptions.parseUserAgent(this.uri);
        ExecuteSqlRequest.QueryOptions.Builder queryOptionsBuilder = ExecuteSqlRequest.QueryOptions.newBuilder();
        queryOptionsBuilder.setOptimizerVersion(ConnectionOptions.parseOptimizerVersion(this.uri));
        this.queryOptions = queryOptionsBuilder.build();
        this.host = matcher.group("HOSTGROUP") == null ? DEFAULT_HOST : (this.usePlainText ? PLAIN_TEXT_PROTOCOL : HOST_PROTOCOL) + matcher.group("HOSTGROUP");
        this.instanceId = matcher.group("INSTANCEGROUP");
        this.databaseName = matcher.group("DATABASEGROUP");
        this.credentials = builder.credentials == null && this.credentialsUrl == null && this.oauthToken == null && this.usePlainText ? NoCredentials.getInstance() : (this.oauthToken != null ? new GoogleCredentials(new AccessToken(this.oauthToken, null)) : (this.fixedCredentials != null ? this.fixedCredentials : this.getCredentialsService().createCredentials(this.credentialsUrl)));
        String numChannelsValue = ConnectionOptions.parseNumChannels(builder.uri);
        if (numChannelsValue != null) {
            try {
                this.numChannels = Integer.valueOf(numChannelsValue);
            }
            catch (NumberFormatException e) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid numChannels value specified: " + numChannelsValue, e);
            }
        } else {
            this.numChannels = null;
        }
        String projectId = matcher.group("PROJECTGROUP");
        if ("DEFAULT_PROJECT_ID".equalsIgnoreCase(projectId)) {
            projectId = ConnectionOptions.getDefaultProjectId(this.credentials);
        }
        this.projectId = projectId;
        this.autocommit = ConnectionOptions.parseAutocommit(this.uri);
        this.readOnly = ConnectionOptions.parseReadOnly(this.uri);
        this.retryAbortsInternally = ConnectionOptions.parseRetryAbortsInternally(this.uri);
        this.statementExecutionInterceptors = Collections.unmodifiableList(builder.statementExecutionInterceptors);
        this.configurator = builder.configurator;
    }

    SpannerOptionsConfigurator getConfigurator() {
        return this.configurator;
    }

    @VisibleForTesting
    CredentialsService getCredentialsService() {
        return CredentialsService.INSTANCE;
    }

    @VisibleForTesting
    static boolean parseUsePlainText(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USE_PLAIN_TEXT_PROPERTY_NAME);
        return value != null ? Boolean.valueOf(value) : false;
    }

    @VisibleForTesting
    static boolean parseAutocommit(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, AUTOCOMMIT_PROPERTY_NAME);
        return value != null ? Boolean.valueOf(value) : true;
    }

    @VisibleForTesting
    static boolean parseReadOnly(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, READONLY_PROPERTY_NAME);
        return value != null ? Boolean.valueOf(value) : false;
    }

    @VisibleForTesting
    static boolean parseRetryAbortsInternally(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, RETRY_ABORTS_INTERNALLY_PROPERTY_NAME);
        return value != null ? Boolean.valueOf(value) : true;
    }

    @VisibleForTesting
    static String parseCredentials(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, CREDENTIALS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_CREDENTIALS;
    }

    @VisibleForTesting
    static String parseOAuthToken(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OAUTH_TOKEN_PROPERTY_NAME);
        return value != null ? value : DEFAULT_OAUTH_TOKEN;
    }

    @VisibleForTesting
    static String parseNumChannels(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, NUM_CHANNELS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_NUM_CHANNELS;
    }

    @VisibleForTesting
    static String parseUserAgent(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USER_AGENT_PROPERTY_NAME);
        return value != null ? value : DEFAULT_USER_AGENT;
    }

    @VisibleForTesting
    static String parseOptimizerVersion(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OPTIMIZER_VERSION_PROPERTY_NAME);
        return value != null ? value : DEFAULT_OPTIMIZER_VERSION;
    }

    @VisibleForTesting
    static String parseUriProperty(String uri, String property) {
        Pattern pattern = Pattern.compile(String.format("(?is)(?:;|\\?)%s=(.*?)(?:;|$)", property));
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    @VisibleForTesting
    static void checkValidProperties(String uri) {
        String invalidProperties = DEFAULT_OPTIMIZER_VERSION;
        List<String> properties = ConnectionOptions.parseProperties(uri);
        for (String property : properties) {
            if (INTERNAL_VALID_PROPERTIES.contains(ConnectionProperty.createEmptyProperty(property))) continue;
            if (invalidProperties.length() > 0) {
                invalidProperties = invalidProperties + ", ";
            }
            invalidProperties = invalidProperties + property;
        }
        Preconditions.checkArgument((boolean)invalidProperties.isEmpty(), (Object)("Invalid properties found in connection URI: " + invalidProperties.toString()));
    }

    @VisibleForTesting
    static List<String> parseProperties(String uri) {
        Pattern pattern = Pattern.compile("(?is)(?:\\?|;)(?<PROPERTY>.*?)=(?:.*?)");
        Matcher matcher = pattern.matcher(uri);
        ArrayList<String> res = new ArrayList<String>();
        while (matcher.find() && matcher.group("PROPERTY") != null) {
            res.add(matcher.group("PROPERTY"));
        }
        return res;
    }

    public Connection getConnection() {
        return new ConnectionImpl(this);
    }

    public String getUri() {
        return this.uri;
    }

    public String getCredentialsUrl() {
        return this.credentialsUrl;
    }

    String getOAuthToken() {
        return this.oauthToken;
    }

    Credentials getFixedCredentials() {
        return this.fixedCredentials;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public Integer getNumChannels() {
        return this.numChannels;
    }

    public String getHost() {
        return this.host;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project ID is not specified");
        Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance ID is not specified");
        Preconditions.checkState((this.databaseName != null ? 1 : 0) != 0, (Object)"Database name is not specified");
        return DatabaseId.of(this.projectId, this.instanceId, this.databaseName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRetryAbortsInternally() {
        return this.retryAbortsInternally;
    }

    boolean isUsePlainText() {
        return this.usePlainText;
    }

    String getUserAgent() {
        return this.userAgent;
    }

    ExecuteSqlRequest.QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    List<StatementExecutionInterceptor> getStatementExecutionInterceptors() {
        return this.statementExecutionInterceptors;
    }

    public String toString() {
        return this.getUri();
    }

    public static class Builder {
        private String uri;
        private String credentialsUrl;
        private String oauthToken;
        private Credentials credentials;
        private SessionPoolOptions sessionPoolOptions;
        private List<StatementExecutionInterceptor> statementExecutionInterceptors = Collections.emptyList();
        private SpannerOptionsConfigurator configurator;
        public static final String SPANNER_URI_FORMAT = "(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?";
        private static final String SPANNER_URI_REGEX = "(?is)^(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$";
        private static final Pattern SPANNER_URI_PATTERN = Pattern.compile("(?is)^(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$");
        private static final String HOST_GROUP = "HOSTGROUP";
        private static final String PROJECT_GROUP = "PROJECTGROUP";
        private static final String INSTANCE_GROUP = "INSTANCEGROUP";
        private static final String DATABASE_GROUP = "DATABASEGROUP";
        private static final String DEFAULT_PROJECT_ID_PLACEHOLDER = "DEFAULT_PROJECT_ID";

        private Builder() {
        }

        private boolean isValidUri(String uri) {
            return SPANNER_URI_PATTERN.matcher(uri).matches();
        }

        public Builder setUri(String uri) {
            Preconditions.checkArgument((boolean)this.isValidUri(uri), (Object)"The specified URI is not a valid Cloud Spanner connection URI. Please specify a URI in the format \"cloudspanner:[//host[:port]]/projects/project-id[/instances/instance-id[/databases/database-name]][\\?property-name=property-value[;property-name=property-value]*]?\"");
            ConnectionOptions.checkValidProperties(uri);
            this.uri = uri;
            return this;
        }

        public Builder setSessionPoolOptions(SessionPoolOptions sessionPoolOptions) {
            Preconditions.checkNotNull((Object)sessionPoolOptions);
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setCredentialsUrl(String credentialsUrl) {
            this.credentialsUrl = credentialsUrl;
            return this;
        }

        public Builder setOAuthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        @VisibleForTesting
        Builder setStatementExecutionInterceptors(List<StatementExecutionInterceptor> interceptors) {
            this.statementExecutionInterceptors = interceptors;
            return this;
        }

        @VisibleForTesting
        Builder setConfigurator(SpannerOptionsConfigurator configurator) {
            this.configurator = (SpannerOptionsConfigurator)Preconditions.checkNotNull((Object)configurator);
            return this;
        }

        @VisibleForTesting
        Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public ConnectionOptions build() {
            Preconditions.checkState((this.uri != null ? 1 : 0) != 0, (Object)"Connection URI is required");
            return new ConnectionOptions(this);
        }
    }

    @VisibleForTesting
    static interface SpannerOptionsConfigurator {
        public void configure(SpannerOptions.Builder var1);
    }

    public static class ConnectionProperty {
        private static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
        private final String name;
        private final String description;
        private final String defaultValue;
        private final String[] validValues;
        private final int hashCode;

        private static ConnectionProperty createStringProperty(String name, String description) {
            return new ConnectionProperty(name, description, ConnectionOptions.DEFAULT_OPTIMIZER_VERSION, null);
        }

        private static ConnectionProperty createBooleanProperty(String name, String description, boolean defaultValue) {
            return new ConnectionProperty(name, description, String.valueOf(defaultValue), BOOLEAN_VALUES);
        }

        private static ConnectionProperty createEmptyProperty(String name) {
            return new ConnectionProperty(name, ConnectionOptions.DEFAULT_OPTIMIZER_VERSION, ConnectionOptions.DEFAULT_OPTIMIZER_VERSION, null);
        }

        private ConnectionProperty(String name, String description, String defaultValue, String[] validValues) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)description);
            Preconditions.checkNotNull((Object)defaultValue);
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
            this.validValues = validValues;
            this.hashCode = name.toLowerCase().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionProperty)) {
                return false;
            }
            return ((ConnectionProperty)o).name.equalsIgnoreCase(this.name);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getValidValues() {
            return this.validValues;
        }

        static /* synthetic */ ConnectionProperty access$000(String x0, String x1, boolean x2) {
            return ConnectionProperty.createBooleanProperty(x0, x1, x2);
        }

        static /* synthetic */ ConnectionProperty access$100(String x0, String x1) {
            return ConnectionProperty.createStringProperty(x0, x1);
        }
    }
}

