/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class AsyncRunnerImpl
implements AsyncRunner {
    private final TransactionRunnerImpl delegate;
    private final SettableApiFuture<Timestamp> commitTimestamp = SettableApiFuture.create();

    AsyncRunnerImpl(TransactionRunnerImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public <R> ApiFuture<R> runAsync(final AsyncRunner.AsyncWork<R> work, Executor executor) {
        final SettableApiFuture res = SettableApiFuture.create();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    res.set(AsyncRunnerImpl.this.runTransaction(work));
                }
                catch (Throwable t) {
                    res.setException(t);
                }
                finally {
                    AsyncRunnerImpl.this.setCommitTimestamp();
                }
            }
        });
        return res;
    }

    private <R> R runTransaction(final AsyncRunner.AsyncWork<R> work) {
        return (R)this.delegate.run(new TransactionRunner.TransactionCallable<R>(){

            @Override
            public R run(TransactionContext transaction) throws Exception {
                try {
                    return work.doWorkAsync(transaction).get();
                }
                catch (ExecutionException e) {
                    throw SpannerExceptionFactory.newSpannerException(e.getCause());
                }
                catch (InterruptedException e) {
                    throw SpannerExceptionFactory.propagateInterrupt(e);
                }
            }
        });
    }

    private void setCommitTimestamp() {
        try {
            this.commitTimestamp.set((Object)this.delegate.getCommitTimestamp());
        }
        catch (Throwable t) {
            this.commitTimestamp.setException(t);
        }
    }

    @Override
    public ApiFuture<Timestamp> getCommitTimestamp() {
        return this.commitTimestamp;
    }
}

